/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import io.grpc.internal.WritableBuffer;

final class ByteArrayWritableBuffer
implements WritableBuffer {
    private final int capacity;
    final byte[] bytes;
    private int index;

    ByteArrayWritableBuffer(int capacityHint) {
        this.bytes = new byte[Math.min(0x100000, Math.max(4096, capacityHint))];
        this.capacity = this.bytes.length;
    }

    public void write(byte[] src, int srcIndex, int length) {
        System.arraycopy(src, srcIndex, this.bytes, this.index, length);
        this.index += length;
    }

    public void write(byte b) {
        this.bytes[this.index++] = b;
    }

    public int writableBytes() {
        return this.capacity - this.index;
    }

    public int readableBytes() {
        return this.index;
    }

    public void release() {
    }
}

