/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractServerStream;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportTracer;
import io.grpc.internal.WritableBufferAllocator;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractWebsocketStreamImpl
extends AbstractServerStream {
    protected final AbstractServerStream.TransportState transportState;
    protected final Session websocketSession;
    protected final InternalLogId logId;
    protected final Attributes attributes;

    public AbstractWebsocketStreamImpl(WritableBufferAllocator bufferAllocator, StatsTraceContext statsTraceCtx, int maxInboundMessageSize, Session websocketSession, InternalLogId logId, Attributes attributes, Logger logger) {
        super(bufferAllocator, statsTraceCtx);
        this.transportState = new WebsocketTransportState(maxInboundMessageSize, statsTraceCtx, new TransportTracer(), logger);
        this.websocketSession = websocketSession;
        this.logId = logId;
        this.attributes = attributes;
    }

    protected static void writeAsciiHeadersToMessage(byte[][] serializedHeaders, ByteBuffer message) {
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            message.put(serializedHeaders[i]);
            message.put((byte)58);
            message.put((byte)32);
            message.put(serializedHeaders[i + 1]);
            message.put((byte)13);
            message.put((byte)10);
        }
    }

    public int streamId() {
        return -1;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void createStream(ServerTransportListener transportListener, String methodName, Metadata headers) {
        this.transportState().runOnTransportThread(() -> {
            transportListener.streamCreated((ServerStream)this, methodName, headers);
            this.transportState().onStreamAllocated();
        });
    }

    public void inboundDataReceived(ReadableBuffer message, boolean endOfStream) {
        this.transportState().runOnTransportThread(() -> this.transportState().inboundDataReceived(message, endOfStream));
    }

    public void transportReportStatus(Status status) {
        this.transportState().runOnTransportThread(() -> this.transportState().transportReportStatus(status));
    }

    public AbstractServerStream.TransportState transportState() {
        return this.transportState;
    }

    protected void cancelSink(Status status) {
        if (!this.websocketSession.isOpen() && Status.Code.DEADLINE_EXCEEDED == status.getCode()) {
            return;
        }
        this.transportState.runOnTransportThread(() -> this.transportState.transportReportStatus(status));
        this.close(Status.CANCELLED.withCause((Throwable)status.asRuntimeException()), new Metadata());
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.transportState.runOnTransportThread(() -> {
            try {
                this.websocketSession.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public final class WebsocketTransportState
    extends AbstractServerStream.TransportState {
        private final SerializingExecutor transportThreadExecutor;
        private final Logger logger;

        private WebsocketTransportState(int maxMessageSize, StatsTraceContext statsTraceCtx, TransportTracer transportTracer, Logger logger) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.transportThreadExecutor = new SerializingExecutor(MoreExecutors.directExecutor());
            this.logger = logger;
        }

        public void runOnTransportThread(Runnable r) {
            this.transportThreadExecutor.execute(r);
        }

        public void bytesRead(int numBytes) {
        }

        public void deframeFailed(Throwable cause) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, String.format("[{%s}] Exception processing message", AbstractWebsocketStreamImpl.this.logId), cause);
            }
            AbstractWebsocketStreamImpl.this.cancel(Status.fromThrowable((Throwable)cause));
        }
    }
}

