/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import com.google.common.io.BaseEncoding;
import io.grpc.Attributes;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.ServerStreamTracer;
import io.grpc.internal.ServerTransportListener;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractWebSocketServerStream
extends Endpoint {
    private static final byte[] BINARY_HEADER_SUFFIX_ARR = "-bin".getBytes(StandardCharsets.US_ASCII);
    protected final ServerTransportListener transportListener;
    protected final List<? extends ServerStreamTracer.Factory> streamTracerFactories;
    protected final int maxInboundMessageSize;
    protected final Attributes attributes;
    protected Session websocketSession;

    protected AbstractWebSocketServerStream(ServerTransportListener transportListener, List<? extends ServerStreamTracer.Factory> streamTracerFactories, int maxInboundMessageSize, Attributes attributes) {
        this.transportListener = transportListener;
        this.streamTracerFactories = streamTracerFactories;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.attributes = attributes;
    }

    protected static Metadata readHeaders(ByteBuffer headerPayload) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        while (headerPayload.hasRemaining()) {
            int nameStart = headerPayload.position();
            while (headerPayload.hasRemaining() && headerPayload.get() != 58) {
            }
            int nameEnd = headerPayload.position() - 1;
            int valueStart = headerPayload.position() + 1;
            while (headerPayload.hasRemaining() && headerPayload.get() != 10) {
            }
            int valueEnd = headerPayload.position() - 2;
            if (valueEnd < valueStart) {
                valueEnd = valueStart;
            }
            int endOfLinePosition = headerPayload.position();
            byte[] headerBytes = new byte[nameEnd - nameStart];
            headerPayload.position(nameStart);
            headerPayload.get(headerBytes);
            byteArrays.add(headerBytes);
            if (Arrays.equals(headerBytes, "content-type".getBytes(StandardCharsets.US_ASCII))) {
                byteArrays.add("grpc+proto".getBytes(StandardCharsets.US_ASCII));
                headerPayload.position(valueEnd);
                continue;
            }
            byte[] valueBytes = new byte[valueEnd - valueStart];
            headerPayload.position(valueStart);
            headerPayload.get(valueBytes);
            if (AbstractWebSocketServerStream.endsWithBinHeaderSuffix(headerBytes)) {
                byteArrays.add(BaseEncoding.base64().decode((CharSequence)ByteBuffer.wrap(valueBytes).asCharBuffer()));
            } else {
                byteArrays.add(valueBytes);
            }
            headerPayload.position(endOfLinePosition);
        }
        byteArrays.add("te".getBytes(StandardCharsets.US_ASCII));
        byteArrays.add("trailers".getBytes(StandardCharsets.US_ASCII));
        return InternalMetadata.newMetadata((byte[][])((byte[][])byteArrays.toArray((T[])new byte[0][])));
    }

    private static boolean endsWithBinHeaderSuffix(byte[] headerBytes) {
        if (headerBytes.length < BINARY_HEADER_SUFFIX_ARR.length) {
            return false;
        }
        for (int i = 0; i < BINARY_HEADER_SUFFIX_ARR.length; ++i) {
            if (headerBytes[headerBytes.length - 3 + i] == BINARY_HEADER_SUFFIX_ARR[i]) continue;
            return false;
        }
        return true;
    }

    public void onOpen(Session websocketSession, EndpointConfig config) {
        this.websocketSession = websocketSession;
        websocketSession.addMessageHandler(String.class, this::onMessage);
        websocketSession.addMessageHandler(ByteBuffer.class, message -> {
            try {
                this.onMessage((ByteBuffer)message);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        websocketSession.setMaxIdleTimeout(0L);
        websocketSession.setMaxBinaryMessageBufferSize(Integer.MAX_VALUE);
    }

    public abstract void onMessage(String var1);

    public abstract void onMessage(ByteBuffer var1) throws IOException;
}

