/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.types;

import de.huxhorn.sulky.ulid.ULID;
import io.datarouter.types.UlidTool;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;

public record Ulid(String value) implements Comparable<Ulid>
{
    public static final int LENGTH = 26;
    private static final ULID ULID_INSTANCE = new ULID();

    public Ulid {
        ULID.parseULID((String)value);
    }

    public Ulid() {
        this(Ulid.newValue());
    }

    public static String newValue() {
        return ULID_INSTANCE.nextULID();
    }

    public long getTimestampMs() {
        return ULID.parseULID((String)this.value).timestamp();
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.getTimestampMs());
    }

    public static Ulid createFirstUlidFromTimestamp(long timestamp) {
        char[] buffer = new char[26];
        UlidTool.internalWriteCrockford(buffer, timestamp &= 0xFFFFFFFFFFFFL, 10, 0);
        int i = 10;
        while (i < 26) {
            buffer[i] = UlidTool.ENCODING_CHARS[0];
            ++i;
        }
        return new Ulid(new String(buffer));
    }

    public static Ulid createUlidFromTimestamp(long timestamp, long seed) {
        Random random = new Random(seed);
        char[] buffer = new char[26];
        UlidTool.internalWriteCrockford(buffer, timestamp &= 0xFFFFFFFFFFFFL, 10, 0);
        UlidTool.internalWriteCrockford(buffer, random.nextLong(), 8, 10);
        UlidTool.internalWriteCrockford(buffer, random.nextLong(), 8, 18);
        return new Ulid(new String(buffer));
    }

    public static Ulid createRandomUlidForTimestamp(long timestamp) {
        return new Ulid(ULID_INSTANCE.nextULID(timestamp));
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(Ulid other) {
        return this.value.compareTo(other.value);
    }

    public String getAsHumanReadableTime(DateTimeFormatter formatter, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(this.getInstant(), zoneId);
        return formatter.format(zonedDateTime);
    }
}

