/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.types;

import de.huxhorn.sulky.ulid.ULID;
import io.datarouter.types.Ulid;
import io.datarouter.types.UlidTool;

public record ReverseUlid(String reverseValue) implements Comparable<ReverseUlid>
{
    public ReverseUlid {
        ULID.parseULID((String)reverseValue);
    }

    public ReverseUlid() {
        this(ReverseUlid.createReverseStringWithReverseTimestamp(new ULID().nextULID()));
    }

    @Override
    public String toString() {
        return this.reverseValue;
    }

    @Override
    public int compareTo(ReverseUlid other) {
        return this.reverseValue.compareTo(other.reverseValue);
    }

    public static ReverseUlid toReverseUlid(Ulid ulid) {
        return new ReverseUlid(ReverseUlid.createReverseStringWithReverseTimestamp(ulid.value()));
    }

    public static Ulid toUlid(ReverseUlid reverseUlid) {
        String reversedValue = reverseUlid.reverseValue();
        return new Ulid(ReverseUlid.createReverseStringWithReverseTimestamp(reversedValue));
    }

    private static String createReverseStringWithReverseTimestamp(String value) {
        long reversedTimestamp = Long.MAX_VALUE - ULID.parseULID((String)value).timestamp();
        long timestamp = reversedTimestamp & 0xFFFFFFFFFFFFL;
        char[] buffer = new char[26];
        UlidTool.internalWriteCrockford(buffer, timestamp, 10, 0);
        return ReverseUlid.reverseRandomPart(value.substring(10).toCharArray(), buffer);
    }

    public static String reverseRandomPart(char[] randomPart, char[] buffer) {
        int charIndex = 10;
        char[] cArray = randomPart;
        int n = randomPart.length;
        int n2 = 0;
        while (n2 < n) {
            char reverseChar;
            char ch = cArray[n2];
            buffer[charIndex] = reverseChar = UlidTool.CHAR_TO_REVERSE_CHAR.get(Character.valueOf(ch)).charValue();
            ++charIndex;
            ++n2;
        }
        return new String(buffer);
    }
}

