/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public record Quad(long bits) implements Comparable<Quad>
{
    private static final long LONG_ALL_BITS = -1L;
    private static final long ONE_MASK = 1L;
    private static final long TWO_MASK = 2L;
    private static final String TOP_QUAD_STRING = "q";
    public static final Quad TOP_QUAD = new Quad();
    public static final Quad EMPTY_STRING_QUAD = new Quad("");
    private static final int NUM_EMPTY_BITS = 1;
    private static final int NUM_BITS_IN_LONG = 64;
    private static final int NUM_LEVELS_AFTER_ZERO = 28;
    private static final int NUM_GRID_BITS = 58;
    private static final int NUM_LEVEL_BITS = 5;
    private static final long ZERO_LEVEL_BITS_WITH_ALL_GRID_BITS = Quad.setLeftBits(59);
    private static final long MAX_LEVEL_BITS_WITH_NO_GRID_BITS = 29L;
    private static final String EIGHT_ZERO_STRING = "00000000";
    public static final String SIXTEEN_ZERO_STRING = "0000000000000000";
    public static final int RIGHT_BIT_TABLE_MASK = 14;
    public static final int[] RIGHT_BIT_LOOK_UP_TABLE = new int[15];

    static {
        int jval = 1;
        Quad.RIGHT_BIT_LOOK_UP_TABLE[0] = 0;
        Quad.RIGHT_BIT_LOOK_UP_TABLE[1] = 1;
        int i = 2;
        while (i <= 14) {
            Quad.RIGHT_BIT_LOOK_UP_TABLE[i] = RIGHT_BIT_LOOK_UP_TABLE[i - 1] + jval * 2;
            jval *= 2;
            ++i;
        }
    }

    public Quad() {
        this(TOP_QUAD_STRING);
    }

    public Quad(long level, long xPosition, long yPosition) {
        this(Quad.levelXyToBits(level, xPosition, yPosition));
    }

    public Quad(String str) {
        this(Quad.stringQuadToBits(str));
    }

    private static long levelXyToBits(long level, long xPosition, long yPosition) {
        if (level < 15L) {
            long rightXBits = xPosition & (long)RIGHT_BIT_LOOK_UP_TABLE[(int)level];
            long dilatedRightXBits = DilatedBits.DILATED_TABLE[(int)rightXBits];
            long rightYBits = yPosition & (long)RIGHT_BIT_LOOK_UP_TABLE[(int)level];
            long dilatedRightYBits = DilatedBits.LEFT_SHIFTED_DILATED_TABLE[(int)rightYBits];
            return level | dilatedRightXBits << (int)(63L - level * 2L) | dilatedRightYBits << (int)(63L - level * 2L);
        }
        long shift = level - 15L;
        long leftXBits = xPosition >>> (int)shift;
        long dilatedLeftXBits = DilatedBits.DILATED_TABLE[(int)leftXBits];
        long rightXBits = xPosition & (long)RIGHT_BIT_LOOK_UP_TABLE[(int)shift];
        long dilatedRightXBits = DilatedBits.DILATED_TABLE[(int)rightXBits];
        long leftYBits = yPosition >>> (int)shift;
        long dilatedLeftYBits = DilatedBits.LEFT_SHIFTED_DILATED_TABLE[(int)leftYBits];
        long rightYBits = yPosition & (long)RIGHT_BIT_LOOK_UP_TABLE[(int)shift];
        long dilatedRightYBits = DilatedBits.LEFT_SHIFTED_DILATED_TABLE[(int)rightYBits];
        return level | dilatedLeftXBits << 33 | dilatedRightXBits << (int)(33L - shift * 2L) | dilatedLeftYBits << 33 | dilatedRightYBits << (int)(33L - shift * 2L);
    }

    private static long stringQuadToBits(String str) {
        if (str == null || str.isEmpty() || TOP_QUAD_STRING.equals(str)) {
            return 0L;
        }
        long length = str.length();
        long xyBits = 0L;
        long workingBits = length;
        int i = 1;
        while ((long)i <= length) {
            if (str.charAt(i - 1) != '0') {
                if (str.charAt(i - 1) == '1') {
                    xyBits |= 1L << 63 - 2 * i;
                } else if (str.charAt(i - 1) == '2') {
                    xyBits |= 2L << 63 - 2 * i;
                } else if (str.charAt(i - 1) == '3') {
                    xyBits |= 3L << 63 - 2 * i;
                }
            }
            ++i;
        }
        return workingBits |= xyBits;
    }

    public long getNumQuadsAcross() {
        long toBeShifted = 1L;
        return toBeShifted << this.getLevel();
    }

    public boolean isRoot() {
        return this.getLevel() == 0;
    }

    public Quad getAtLevel(int level) {
        long levelBits = this.levelBitsAtLevel(level);
        long formattedGridBitsAtLevel = this.gridBitsAtLevel(level) << 63 - level * 2;
        return new Quad(levelBits | formattedGridBitsAtLevel);
    }

    public Quad getLastPossibleSubQuad() {
        int shift = 63 - this.getLevel() * 2;
        long levelRemoved = this.getGridBits() << shift;
        long lowerLevelsFilledIn = levelRemoved | Quad.setRightBits(shift);
        long clearLevelBits = lowerLevelsFilledIn & ZERO_LEVEL_BITS_WITH_ALL_GRID_BITS;
        long maxLevelApplied = clearLevelBits | 0x1DL;
        return new Quad(maxLevelApplied);
    }

    public Quad getLastPossibleSubQuadAtLevel(int level) {
        int shift = 63 - this.getLevel() * 2;
        long levelRemoved = this.getGridBits() << shift;
        long lowerLevelsFilledIn = levelRemoved | Quad.setRightBits(shift);
        long clearLevelBits = lowerLevelsFilledIn & Quad.setLeftBits(2 * level + 1);
        long maxLevelApplied = clearLevelBits | (long)level;
        return new Quad(maxLevelApplied);
    }

    public int getLevel() {
        return (int)(this.bits & (long)RIGHT_BIT_LOOK_UP_TABLE[5]);
    }

    public long getX() {
        long xposition = 0L;
        long level = this.getLevel();
        long shift = 63L - level * 2L;
        int bit = 0;
        while (bit < 58) {
            long mask = 1L << bit;
            long workingBit = this.bits >>> (int)shift & mask;
            long contractedWorkingBit = workingBit >>> bit / 2;
            xposition += contractedWorkingBit;
            bit = (short)(bit + 2);
        }
        return xposition;
    }

    public long getY() {
        long yposition = 0L;
        long level = this.getLevel();
        long shift = 63L - level * 2L;
        int bit = 1;
        while (bit < 58) {
            long mask = 1L << bit;
            long workingBit = this.bits >>> (int)shift & mask;
            long contractedWorkingBit = workingBit >>> bit / 2 + 1;
            yposition += contractedWorkingBit;
            bit = (short)(bit + 2);
        }
        return yposition;
    }

    public boolean isXEven() {
        return (this.getGridBits() & 1L) != 1L;
    }

    public boolean isYEven() {
        return (this.getGridBits() & 2L) != 2L;
    }

    private long gridBitsAtLevel(int level) {
        int levelsDeeper = level - this.getLevel();
        if (levelsDeeper > 0) {
            return this.getGridBits() << 2 * levelsDeeper;
        }
        if (levelsDeeper < 0) {
            return this.getGridBits() >>> -2 * levelsDeeper;
        }
        return this.getGridBits();
    }

    public long getGridBits() {
        long shift = 63 - this.getLevel() * 2;
        long gridBits = this.bits >> (int)shift;
        return gridBits;
    }

    private long levelBitsAtLevel(int level) {
        return level;
    }

    public Quad getParent() {
        return this.getAtLevel(this.getLevel() - 1);
    }

    public List<Quad> getChildren() {
        int shift = 63 - this.getLevel() * 2;
        long gridBits = this.getGridBits();
        long length = this.getLevel();
        long currentChild = ++length;
        long formattedGridBits = (gridBits <<= 2) << shift - 2;
        currentChild |= formattedGridBits;
        ArrayList<Quad> children = new ArrayList<Quad>(4);
        int i = 0;
        while (i < 4) {
            children.add(new Quad(currentChild));
            currentChild = length;
            formattedGridBits = ++gridBits << shift - 2;
            currentChild |= formattedGridBits;
            ++i;
        }
        return children;
    }

    public List<Quad> getDescendantAtLevel(int level) {
        ArrayList<Quad> descendant = new ArrayList<Quad>();
        int tempLevel = this.getLevel();
        if (tempLevel < level) {
            List<Quad> children = this.getChildren();
            for (Quad child : children) {
                descendant.addAll(child.getDescendantAtLevel(level));
            }
        } else if (tempLevel == level) {
            descendant.add(this);
        }
        return descendant;
    }

    public List<Quad> get3Siblings() {
        if (this.isRoot()) {
            return null;
        }
        int shift = 63 - this.getLevel() * 2;
        ArrayList<Quad> siblings = new ArrayList<Quad>(3);
        long currentSibling = (this.getGridBits() | 3L) - 3L;
        int i = 0;
        while (i < 4) {
            if (this.getGridBits() != currentSibling) {
                long formattedSibling = currentSibling << shift | (long)this.getLevel();
                siblings.add(new Quad(formattedSibling));
            }
            ++currentSibling;
            ++i;
        }
        return siblings;
    }

    public boolean isParentOfOrEqualTo(Quad other) {
        if (this.getLevel() > other.getLevel()) {
            return false;
        }
        return this.gridBitsAtLevel(this.getLevel()) == other.gridBitsAtLevel(this.getLevel());
    }

    public boolean isChildOfOrEqualTo(Quad other) {
        if (this.getLevel() < other.getLevel()) {
            return false;
        }
        return this.gridBitsAtLevel(other.getLevel()) == other.getGridBits();
    }

    public boolean isChildOf(Quad other) {
        if (this.getLevel() <= other.getLevel()) {
            return false;
        }
        return this.gridBitsAtLevel(other.getLevel()) == other.getGridBits();
    }

    public Quad shiftLeft() {
        long distance = 0L;
        int currentBit = 0;
        int shift = 63 - this.getLevel() * 2;
        while ((this.getGridBits() >> currentBit & 1L) == 0L) {
            distance <<= 1;
            ++distance;
            distance <<= 1;
            currentBit += 2;
        }
        long newBits = this.getGridBits() - ++distance << shift | (long)this.getLevel();
        return new Quad(newBits);
    }

    public Quad shiftRight() {
        long distance = 0L;
        int currentBit = 0;
        int shift = 63 - this.getLevel() * 2;
        while ((this.getGridBits() >> currentBit & 1L) == 1L) {
            distance <<= 1;
            ++distance;
            distance <<= 1;
            currentBit += 2;
        }
        long newBits = this.getGridBits() + ++distance << shift | (long)this.getLevel();
        return new Quad(newBits);
    }

    public Quad shiftUp() {
        long oneMask = 1L;
        long distance = 0L;
        int currentBit = 1;
        int shift = 63 - this.getLevel() * 2;
        while ((this.getGridBits() >> currentBit & oneMask) == 0L) {
            distance <<= 1;
            ++distance;
            distance <<= 1;
            currentBit += 2;
        }
        ++distance;
        long newBits = this.getGridBits() - (distance <<= 1) << shift | (long)this.getLevel();
        return new Quad(newBits);
    }

    public Quad shiftDown() {
        long oneMask = 1L;
        long distance = 0L;
        int currentBit = 1;
        int shift = 63 - this.getLevel() * 2;
        while ((this.getGridBits() >> currentBit & oneMask) == 1L) {
            distance <<= 1;
            ++distance;
            distance <<= 1;
            currentBit += 2;
        }
        ++distance;
        long newBits = this.getGridBits() + (distance <<= 1) << shift | (long)this.getLevel();
        return new Quad(newBits);
    }

    public String toMicrosoftStyleString() {
        int length = this.getLevel();
        char[] val = new char[length];
        long xyBits = this.bits >>> 63 - length * 2;
        int i = 0;
        while (i < length) {
            long twoBits = xyBits >>> i * 2 & 3L;
            if (twoBits == 0L) {
                val[length - i - 1] = 48;
            } else if (twoBits == 1L) {
                val[length - i - 1] = 49;
            } else if (twoBits == 2L) {
                val[length - i - 1] = 50;
            } else if (twoBits == 3L) {
                val[length - i - 1] = 51;
            }
            ++i;
        }
        return new String(val);
    }

    @Deprecated
    public String getMicrosoftStyleString() {
        return this.toMicrosoftStyleString();
    }

    public static String getLastPossibleSubQuadFromString(String quadString) {
        Quad quad = new Quad(quadString);
        return quad.getLastPossibleSubQuad().toMicrosoftStyleString();
    }

    public static List<Quad> fromMicrosoftStyleStrings(Collection<String> microsoftStrings) {
        return microsoftStrings.stream().map(Quad::new).toList();
    }

    private static long setRightBits(int numSetBitsOnRight) {
        return -1L >>> 64 - numSetBitsOnRight;
    }

    private static long setLeftBits(int numSetBitsOnLeft) {
        return -1L << 64 - numSetBitsOnLeft;
    }

    @Override
    public String toString() {
        return this.toMicrosoftStyleString();
    }

    @Override
    public int compareTo(Quad other) {
        if (this.bits < other.bits) {
            return -1;
        }
        if (this.bits > other.bits) {
            return 1;
        }
        return 0;
    }

    public static class DilatedBits {
        public static final int MAX_BITS = 15;
        public static final int MAX_DILATED_BITS = 30;
        public static final int HALF_GRID_BITS = 15;
        public static final int TABLE_SLOTS = 32768;
        public static final int TABLE_MASK = Short.MAX_VALUE;
        public static final int[] DILATED_TABLE = new int[32768];
        public static final int[] LEFT_SHIFTED_DILATED_TABLE = new int[32768];

        static {
            int i = 0;
            while (i < 32768) {
                int dilated = 0;
                int shift = 0;
                while (shift < 15) {
                    int dilatedShiftedLeft;
                    int mask = 1 << shift;
                    int workingBit = i & mask;
                    int dilatedWorkingBit = workingBit << shift;
                    DilatedBits.DILATED_TABLE[i] = dilated += dilatedWorkingBit;
                    DilatedBits.LEFT_SHIFTED_DILATED_TABLE[i] = dilatedShiftedLeft = dilated << 1;
                    shift = (short)(shift + 1);
                }
                ++i;
            }
        }
    }
}

