/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.types;

import io.datarouter.types.BaseMilliTime;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;

public final class MilliTimeReversed
implements BaseMilliTime<MilliTimeReversed>,
Comparable<MilliTimeReversed> {
    public static final MilliTimeReversed MIN = new MilliTimeReversed(Long.MAX_VALUE);
    public static final MilliTimeReversed MAX = new MilliTimeReversed(0L);
    private final long reversedEpochMilli;

    private MilliTimeReversed(long reversedEpochMilli) {
        this.reversedEpochMilli = reversedEpochMilli;
    }

    public static MilliTimeReversed ofEpochMilli(long epochMilli) {
        return new MilliTimeReversed(Long.MAX_VALUE - epochMilli);
    }

    public static MilliTimeReversed ofReversedEpochMilli(long reversedEpochMilli) {
        return new MilliTimeReversed(reversedEpochMilli);
    }

    public static MilliTimeReversed of(Instant instant) {
        return MilliTimeReversed.ofEpochMilli(instant.toEpochMilli());
    }

    public static MilliTimeReversed of(Date date) {
        return MilliTimeReversed.ofEpochMilli(date.getTime());
    }

    public static MilliTimeReversed of(ZonedDateTime date) {
        return MilliTimeReversed.of(date.toInstant());
    }

    @Override
    public int compareTo(MilliTimeReversed other) {
        return Long.compare(this.reversedEpochMilli, other.reversedEpochMilli);
    }

    public String toString() {
        return Long.toString(this.reversedEpochMilli);
    }

    public int hashCode() {
        return Long.hashCode(this.reversedEpochMilli);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MilliTimeReversed other = (MilliTimeReversed)obj;
        return Objects.equals(this.reversedEpochMilli, other.reversedEpochMilli);
    }

    @Override
    public long toEpochMilli() {
        return Long.MAX_VALUE - this.reversedEpochMilli;
    }

    @Override
    public long toReversedEpochMilli() {
        return this.reversedEpochMilli;
    }

    public static MilliTimeReversed now() {
        return MilliTimeReversed.ofEpochMilli(System.currentTimeMillis());
    }
}

