/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.types;

import io.datarouter.types.BaseMilliTime;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.Objects;

public final class MilliTime
implements BaseMilliTime<MilliTime>,
Comparable<MilliTime> {
    public static final MilliTime MIN = new MilliTime(0L);
    public static final MilliTime MAX = new MilliTime(Long.MAX_VALUE);
    private final long epochMilli;

    private MilliTime(long epochMilli) {
        this.epochMilli = epochMilli;
    }

    public static MilliTime ofEpochMilli(long epochMilli) {
        return new MilliTime(epochMilli);
    }

    public static MilliTime ofReversedEpochMilli(long reversedEpochMilli) {
        return MilliTime.ofEpochMilli(Long.MAX_VALUE - reversedEpochMilli);
    }

    public static MilliTime of(Instant instant) {
        return MilliTime.ofEpochMilli(instant.toEpochMilli());
    }

    public static MilliTime of(Date date) {
        return MilliTime.ofEpochMilli(date.getTime());
    }

    public static MilliTime of(ZonedDateTime date) {
        return MilliTime.of(date.toInstant());
    }

    @Override
    public int compareTo(MilliTime other) {
        return Long.compare(this.epochMilli, other.epochMilli);
    }

    public String toString() {
        return Long.toString(this.epochMilli);
    }

    public int hashCode() {
        return Long.hashCode(this.epochMilli);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MilliTime other = (MilliTime)obj;
        return Objects.equals(this.epochMilli, other.epochMilli);
    }

    @Override
    public long toEpochMilli() {
        return this.epochMilli;
    }

    @Override
    public long toReversedEpochMilli() {
        return Long.MAX_VALUE - this.epochMilli;
    }

    public static MilliTime now() {
        return MilliTime.ofEpochMilli(System.currentTimeMillis());
    }

    public static MilliTime atStartOfDay(ZoneId zoneId) {
        long timeMs = LocalDateTime.ofInstant(Instant.now(), zoneId).with(LocalTime.MIN).atZone(zoneId).toInstant().toEpochMilli();
        return MilliTime.ofEpochMilli(timeMs);
    }

    public static MilliTime atEndOfDay(ZoneId zoneId) {
        long timeMs = LocalDateTime.ofInstant(Instant.now(), zoneId).with(LocalTime.MAX).atZone(zoneId).toInstant().toEpochMilli();
        return MilliTime.ofEpochMilli(timeMs);
    }

    public boolean isBefore(MilliTime milliTime) {
        return this.compareTo(milliTime) < 0;
    }

    public boolean isBeforeOrEqual(MilliTime milliTime) {
        return this.compareTo(milliTime) <= 0;
    }

    public boolean isAfter(MilliTime milliTime) {
        return this.compareTo(milliTime) > 0;
    }

    public boolean isAfterOrEqual(MilliTime milliTime) {
        return this.compareTo(milliTime) >= 0;
    }

    public MilliTime plus(long timeToAdd, TemporalUnit unit) {
        return this.plus(Duration.of(timeToAdd, unit));
    }

    public MilliTime plus(MilliTime milliTime) {
        return this.plus(milliTime.toEpochMilli(), ChronoUnit.MILLIS);
    }

    public MilliTime plus(Duration duration) {
        return MilliTime.ofEpochMilli(this.toEpochMilli() + duration.toMillis());
    }

    public MilliTime minus(long timeToSubtract, TemporalUnit unit) {
        return this.minus(Duration.of(timeToSubtract, unit));
    }

    public MilliTime minus(MilliTime milliTime) {
        return this.minus(milliTime.toEpochMilli(), ChronoUnit.MILLIS);
    }

    public MilliTime minus(Duration duration) {
        return MilliTime.ofEpochMilli(this.toEpochMilli() - duration.toMillis());
    }

    public static MilliTime parse(CharSequence text) {
        Instant instant = DateTimeFormatter.ISO_INSTANT.parse(text, Instant::from);
        return MilliTime.of(instant);
    }

    public static MilliTime max(MilliTime time1, MilliTime time2) {
        return time1.toEpochMilli() >= time2.toEpochMilli() ? time1 : time2;
    }

    public static MilliTime min(MilliTime time1, MilliTime time2) {
        return time1.toEpochMilli() <= time2.toEpochMilli() ? time1 : time2;
    }
}

