/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.types;

import io.datarouter.types.MilliTime;
import io.datarouter.types.MilliTimeReversed;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public interface BaseMilliTime<T extends BaseMilliTime<T>> {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss zzz");

    public long toEpochMilli();

    public long toReversedEpochMilli();

    default public MilliTime toMilliTime() {
        return MilliTime.ofEpochMilli(this.toEpochMilli());
    }

    default public MilliTimeReversed toMilliTimeReversed() {
        return MilliTimeReversed.ofReversedEpochMilli(this.toReversedEpochMilli());
    }

    default public Instant toInstant() {
        return Instant.ofEpochMilli(this.toEpochMilli());
    }

    default public Date toDate() {
        return new Date(this.toEpochMilli());
    }

    default public String format(ZoneId zoneId) {
        return this.format(FORMATTER, zoneId);
    }

    default public String format(DateTimeFormatter formatter, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(this.toInstant(), zoneId);
        return formatter.format(zonedDateTime);
    }

    default public Duration age() {
        long ageMs = System.currentTimeMillis() - this.toEpochMilli();
        return Duration.ofMillis(ageMs);
    }

    default public boolean isOlderThan(Duration duration) {
        long cutoff = System.currentTimeMillis() - duration.toMillis();
        return this.toEpochMilli() < cutoff;
    }
}

