/*
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.types;

import java.time.Instant;
import java.util.Random;

import de.huxhorn.sulky.ulid.ULID;

public record Ulid(
		String value)
implements Comparable<Ulid>{

	public static final int LENGTH = 26;

	private static final ULID ULID_INSTANCE = new ULID();

	public Ulid{
		ULID.parseULID(value);
	}

	public Ulid(){
		this(newValue());
	}

	public static String newValue(){
		return ULID_INSTANCE.nextULID();
	}

	public long getTimestampMs(){
		return ULID.parseULID(value).timestamp();
	}

	public Instant getInstant(){
		return Instant.ofEpochMilli(getTimestampMs());
	}

	public static Ulid createFirstUlidFromTimestamp(long timestamp){
		timestamp = timestamp & UlidTool.TIMESTAMP_MASK;

		char[] buffer = new char[26];

		UlidTool.internalWriteCrockford(buffer, timestamp, 10, 0);
		for(int i = 10; i < 26; i++){
			buffer[i] = UlidTool.ENCODING_CHARS[0];
		}
		return new Ulid(new String(buffer));
	}

	public static Ulid createUlidFromTimestamp(long timestamp, long seed){
		Random random = new Random(seed);
		timestamp = timestamp & UlidTool.TIMESTAMP_MASK;

		char[] buffer = new char[26];

		UlidTool.internalWriteCrockford(buffer, timestamp, 10, 0);
		UlidTool.internalWriteCrockford(buffer, random.nextLong(), 8, 10);
		UlidTool.internalWriteCrockford(buffer, random.nextLong(), 8, 18);
		return new Ulid(new String(buffer));
	}

	@Override
	public String toString(){
		return value;
	}

	@Override
	public int compareTo(Ulid other){
		return value.compareTo(other.value);
	}

}
