/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullsTool {
    private static final Logger logger = LoggerFactory.getLogger(NullsTool.class);
    private static final Set<String> locations = ConcurrentHashMap.newKeySet();
    private static final Set<String> stacks = ConcurrentHashMap.newKeySet();

    public static <T> T log(T item, String location) {
        if (item == null) {
            NullsTool.logIfNew(location);
        }
        return item;
    }

    public static <T> T log(T item, Object caller, String location) {
        if (item == null) {
            NullsTool.logIfNew(String.valueOf(caller.getClass().getSimpleName()) + "." + location);
        }
        return item;
    }

    public static <T> T log(T item, Class<?> callerClass, String location) {
        if (item == null) {
            NullsTool.logIfNew(String.valueOf(callerClass.getSimpleName()) + "." + location);
        }
        return item;
    }

    public static <T> T log(T item, Object caller) {
        if (item == null) {
            NullsTool.logIfNew(caller.getClass().getSimpleName());
        }
        return item;
    }

    public static <T> T log(T item, Class<?> callerClass) {
        if (item == null) {
            NullsTool.logIfNew(callerClass.getSimpleName());
        }
        return item;
    }

    public static <T> T logStackIfNull(T item) {
        if (item == null) {
            NullsTool.logIfNewStack();
        }
        return item;
    }

    private static void logIfNew(String location) {
        if (locations.add(location)) {
            logger.warn("added {} to {}", (Object)location, locations);
        }
    }

    private static void logIfNewStack() {
        String relevantStackTrace = StackWalker.getInstance().walk(stackStream -> stackStream.filter(stack -> !stack.getClassName().equals(NullsTool.class.getName())).limit(10L).filter(stack -> stack.getClassName().contains("com.hotpads.")).map(stack -> String.valueOf(stack.getClassName()) + ":" + stack.getMethodName() + ":" + stack.getLineNumber()).collect(Collectors.joining("\n\t")));
        if (stacks.add(relevantStackTrace)) {
            logger.warn("null for stack:\n\t{}", (Object)relevantStackTrace);
        }
    }
}

