/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.number.NumberFormatter;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIndexingNodeVacuum<PK extends RegularPrimaryKey<PK>, T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseIndexingNodeVacuum.class);
    private final Scanner<T> scanner;
    private final int deleteBatchSize;
    private final Consumer<Collection<PK>> deleteConsumer;
    private final Optional<Integer> logBatchSize;
    private final Predicate<T> shouldDelete;

    protected BaseIndexingNodeVacuum(Scanner<T> scanner, Consumer<Collection<PK>> deleteConsumer, int deleteBatchSize, Optional<Integer> logBatchSize, Predicate<T> shouldDelete) {
        this.scanner = scanner;
        this.deleteBatchSize = deleteBatchSize;
        this.deleteConsumer = deleteConsumer;
        this.logBatchSize = logBatchSize;
        this.shouldDelete = shouldDelete;
    }

    protected abstract PK getKey(T var1);

    public void run(TaskTracker tracker) {
        AtomicLong numDeleted = new AtomicLong();
        this.scanner.advanceUntil($ -> tracker.shouldStop()).each($ -> {
            TaskTracker taskTracker2 = tracker.increment();
        }).each(item -> {
            TaskTracker taskTracker2 = tracker.setLastItemProcessed(item.toString());
        }).each($ -> {
            if (this.logBatchSize.isPresent() && tracker.getCount() % (long)this.logBatchSize.get().intValue() == 0L) {
                this.logProgress(numDeleted.get(), tracker.getCount(), tracker.getLastItem());
            }
        }).include(this.shouldDelete).map(this::getKey).batch(this.deleteBatchSize).each(this.deleteConsumer::accept).map(Collection::size).forEach(numDeleted::addAndGet);
        this.logProgress(numDeleted.get(), tracker.getCount(), tracker.getLastItem());
    }

    private void logProgress(long numDeleted, long numScanned, String lastItem) {
        logger.info("deleted {}/{} through {}", new Object[]{NumberFormatter.addCommas((Number)numDeleted), NumberFormatter.addCommas((Number)numScanned), lastItem});
    }

    public static abstract class BaseIndexingNodeVacuumBuilder<PK extends RegularPrimaryKey<PK>, T, C extends BaseIndexingNodeVacuumBuilder<PK, T, C>> {
        protected final Scanner<T> scanner;
        protected final Predicate<T> shouldDelete;
        protected final Consumer<Collection<PK>> deleteConsumer;
        protected int deleteBatchSize;
        protected Optional<Integer> logBatchSize;

        public BaseIndexingNodeVacuumBuilder(Scanner<T> scanner, Predicate<T> shouldDelete, Consumer<Collection<PK>> deleteConsumer) {
            this.scanner = scanner;
            this.shouldDelete = shouldDelete;
            this.deleteConsumer = deleteConsumer;
            this.deleteBatchSize = 100;
            this.logBatchSize = Optional.empty();
        }

        protected abstract C self();

        public C withDeleteBatchSize(int batchSize) {
            this.deleteBatchSize = batchSize;
            return this.self();
        }

        public C withLogBatchSize(int logBatchSize) {
            this.logBatchSize = Optional.of(logBatchSize);
            return this.self();
        }
    }
}

