/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting.cached.impl;

import io.datarouter.instrumentation.refreshable.BaseMemoizedRefreshableSupplier;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.storage.setting.type.StringSetting;
import java.time.Duration;

public class StringCachedSetting
extends CachedSetting<String>
implements StringSetting {
    public StringCachedSetting(SettingFinder finder, String name, DefaultSettingValue<String> defaultValue) {
        super(finder, name, defaultValue);
    }

    @Override
    public boolean isValid(String value) {
        return true;
    }

    public static class RefreshableStringCachedSetting
    extends BaseMemoizedRefreshableSupplier<String> {
        private final CachedSetting<String> setting;

        public RefreshableStringCachedSetting(CachedSetting<String> setting) {
            this(setting, Duration.ofSeconds(30L));
        }

        public RefreshableStringCachedSetting(CachedSetting<String> setting, Duration minimumTtl) {
            this(setting, minimumTtl, minimumTtl);
        }

        public RefreshableStringCachedSetting(CachedSetting<String> setting, Duration minimumTtl, Duration attemptInterval) {
            super(minimumTtl, attemptInterval);
            this.setting = setting;
            this.refresh();
        }

        protected String readNewValue() {
            this.setting.expire();
            return (String)this.setting.get();
        }

        protected String getIdentifier() {
            return this.setting.getName();
        }
    }
}

