/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting.cached;

import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.ConfigDirectoryConstants;
import io.datarouter.storage.servertype.DatarouterServerTypeDetector;
import io.datarouter.storage.setting.DatarouterSettingTag;
import io.datarouter.util.cached.Cached;
import io.datarouter.util.properties.PropertiesTool;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CachedClusterSettingTags
extends Cached<List<DatarouterSettingTag>> {
    private static final Logger logger = LoggerFactory.getLogger(CachedClusterSettingTags.class);
    private static final String DEFAULT_CONFIG_FILENAME = "clusterSetting.properties";
    private static final String PROPERTY_TAGS_NAME = "tags";
    private final DatarouterServerTypeDetector datarouterServerTypeDetector;

    @Inject
    public CachedClusterSettingTags(DatarouterServerTypeDetector datarouterServerTypeDetector) {
        super(15L, TimeUnit.SECONDS);
        this.datarouterServerTypeDetector = datarouterServerTypeDetector;
    }

    protected List<DatarouterSettingTag> reload() {
        if (!this.datarouterServerTypeDetector.mightBeDevelopment()) {
            return List.of();
        }
        String configFileLocation = CachedClusterSettingTags.getConfigFilePath();
        try {
            Properties properties = PropertiesTool.parse((String)configFileLocation);
            logger.info("Got clusterSetting properties from file {}", (Object)configFileLocation);
            if (properties.containsKey(PROPERTY_TAGS_NAME)) {
                return Scanner.of((Object[])properties.getProperty(PROPERTY_TAGS_NAME).split(",")).map(DatarouterSettingTag::new).list();
            }
        }
        catch (RuntimeException e1) {
            logger.info("", (Throwable)e1);
            File file = new File(configFileLocation);
            try {
                file.createNewFile();
                logger.warn("Created clusterSetting properties file {}", (Object)configFileLocation);
            }
            catch (IOException e2) {
                throw new RuntimeException("failed to create properties file " + configFileLocation);
            }
        }
        return List.of();
    }

    public void writeToFile(String value) {
        Properties props = new Properties();
        props.setProperty(PROPERTY_TAGS_NAME, value);
        PropertiesTool.writeToFile((Properties)props, (String)CachedClusterSettingTags.getConfigFilePath());
    }

    public static String getConfigFilePath() {
        return String.valueOf(ConfigDirectoryConstants.getConfigDirectory()) + '/' + DEFAULT_CONFIG_FILENAME;
    }
}

