/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.servertype;

import io.datarouter.storage.config.environment.EnvironmentType;
import io.datarouter.storage.config.properties.DatarouterEnvironmentTypeSupplier;
import io.datarouter.storage.config.properties.DatarouterServerTypeSupplier;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypeDetector;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterServerTypeDetector
implements ServerTypeDetector {
    private final String environmentType;
    private final ServerType serverType;
    private final String environment;

    @Inject
    protected DatarouterServerTypeDetector(DatarouterServerTypeSupplier serverType, DatarouterEnvironmentTypeSupplier environmentType, EnvironmentName environmentName) {
        this.environmentType = environmentType.get();
        this.serverType = serverType.get();
        this.environment = environmentName.get();
    }

    @Override
    public boolean mightBeProduction() {
        if (this.serverType.isProduction()) {
            return true;
        }
        if (this.environmentType.equals(EnvironmentType.PRODUCTION.get().getPersistentString())) {
            return true;
        }
        return this.environment.equals(EnvironmentType.PRODUCTION.get().getPersistentString()) || this.getAdditionalProductionEnvironments().contains(this.environment);
    }

    @Override
    public boolean mightBeDevelopment() {
        return EnvironmentType.DEVELOPMENT.get().getPersistentString().equals(this.environmentType);
    }

    protected Set<String> getAdditionalProductionEnvironments() {
        return Set.of();
    }
}

