/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.op.scan;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ManagedIndexIndexToDatabeanScanner<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>>
extends BaseScanner<D> {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private final MapStorageReader<PK, D> mainNode;
    private final Iterator<List<IE>> indexEntryBatchIterator;
    private final Config config;
    private Iterator<IE> indexEntryIterator;
    private Map<PK, D> keyToDatabeans;

    public ManagedIndexIndexToDatabeanScanner(MapStorageReader<PK, D> mainNode, Scanner<IE> indexScanner, Config config) {
        this.mainNode = mainNode;
        this.config = config;
        int batchSize = config.findInputBatchSize().orElse(100);
        this.indexEntryBatchIterator = indexScanner.batch(batchSize).iterator();
    }

    public boolean advance() {
        if (!(this.indexEntryIterator != null && this.indexEntryIterator.hasNext() || this.doLoad())) {
            return false;
        }
        this.current = (Databean)this.keyToDatabeans.get(((IndexEntry)this.indexEntryIterator.next()).getTargetKey());
        return true;
    }

    private boolean doLoad() {
        if (!this.indexEntryBatchIterator.hasNext()) {
            return false;
        }
        List<IE> indexEntryBatch = this.indexEntryBatchIterator.next();
        this.keyToDatabeans = ((List)Scanner.of(indexEntryBatch).map(IndexEntry::getTargetKey).listTo(primaryKeys -> this.mainNode.getMulti((Collection<PK>)primaryKeys, this.config))).stream().collect(Collectors.toMap(Databean::getKey, Function.identity()));
        this.indexEntryIterator = indexEntryBatch.iterator();
        return true;
    }
}

