/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.raw.read;

import io.datarouter.bytes.split.ChunkScannerTool;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.util.Subpath;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public interface BlobStorageReader
extends NodeOps<PathbeanKey, Pathbean> {
    public String getBucket();

    public Subpath getRootPath();

    public boolean exists(PathbeanKey var1);

    public Optional<Long> length(PathbeanKey var1);

    public byte[] read(PathbeanKey var1);

    public byte[] read(PathbeanKey var1, long var2, int var4);

    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> var1);

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath var1);

    public Scanner<List<Pathbean>> scanPaged(Subpath var1);

    default public Scanner<PathbeanKey> scanKeys(Subpath subpath) {
        return this.scanKeysPaged(subpath).concat(Scanner::of);
    }

    default public Scanner<Pathbean> scan(Subpath subpath) {
        return this.scanPaged(subpath).concat(Scanner::of);
    }

    default public Scanner<byte[]> scanChunks(PathbeanKey key, ExecutorService exec, int numThreads, int chunkSize) {
        long totalLength = this.length(key).orElseThrow();
        return ChunkScannerTool.scanChunks((long)totalLength, (int)chunkSize).parallel(new ParallelScannerContext(exec, numThreads, false)).map(range -> this.read(key, range.start, range.length));
    }
}

