/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.client.imp.QueueClientNodeFactory;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.GroupQueueNodeBuilder;
import io.datarouter.storage.node.builder.QueueNodeBuilder;
import io.datarouter.storage.node.builder.SingleQueueNodeBuilder;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class QueueNodeFactory {
    @Inject
    private DatarouterInjector injector;
    @Inject
    private Datarouter datarouter;
    @Inject
    private DatarouterClients clients;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> QueueNodeBuilder<PK, D, F> createSingleQueue(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new SingleQueueNodeBuilder(this.datarouter, this, clientId, databeanSupplier, fielderSupplier);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> QueueNodeBuilder<PK, D, F> createGroupQueue(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new GroupQueueNodeBuilder(this.datarouter, this, clientId, databeanSupplier, fielderSupplier);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createSingleQueueNode(ClientId clientId, Supplier<D> databeanSupplier, String queueName, Supplier<F> fielderSupplier, String namespace, String queueUrl, boolean isSystemTable) {
        NodeParams params = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withTableName(queueName).withNamespace(namespace).withQueueUrl(queueUrl).withIsSystemTable(isSystemTable).build();
        ClientType<?, ?> clientType = this.clients.getClientTypeInstance(clientId);
        QueueClientNodeFactory clientFactories = this.getClientFactories(clientType);
        return BaseNodeFactory.cast(clientFactories.createSingleQueueNode(params));
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createGroupQueueNode(ClientId clientId, Supplier<D> databeanSupplier, String queueName, Supplier<F> fielderSupplier, String namespace, String queueUrl, boolean isSystemTable) {
        NodeParams params = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withTableName(queueName).withNamespace(namespace).withQueueUrl(queueUrl).withIsSystemTable(isSystemTable).build();
        ClientType<?, ?> clientType = this.clients.getClientTypeInstance(clientId);
        QueueClientNodeFactory clientFactories = this.getClientFactories(clientType);
        return BaseNodeFactory.cast(clientFactories.createGroupQueueNode(params));
    }

    private QueueClientNodeFactory getClientFactories(ClientType<?, ?> clientType) {
        return (QueueClientNodeFactory)this.injector.getInstance(clientType.getClientNodeFactoryClass());
    }
}

