/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.file;

import io.datarouter.instrumentation.count.Counters;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.Require;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Directory
implements BlobStorage {
    private final BlobStorage parent;
    private final Subpath subpathInParent;
    private final String counterName;

    public Directory(BlobStorage parent) {
        this(parent, Subpath.empty(), null);
    }

    public Directory(BlobStorage parent, Subpath subpathInParent) {
        this(parent, subpathInParent, null);
    }

    public Directory(BlobStorage parent, Subpath subpathInParent, String counterName) {
        this.parent = parent;
        this.subpathInParent = subpathInParent;
        this.counterName = counterName;
    }

    public Directory subdirectory(Subpath subpathInParent) {
        return new Directory(this, subpathInParent);
    }

    public Directory subdirectory(Subpath subpathInParent, String counterName) {
        return new Directory(this, subpathInParent, counterName);
    }

    @Override
    public void write(PathbeanKey key, byte[] value) {
        this.parent.write(this.prependStoragePath(key), value);
        this.count("write ops", 1L);
        this.count("write bytes", value.length);
    }

    @Override
    public void write(PathbeanKey key, Scanner<byte[]> chunks) {
        Scanner chunksWithCounts = chunks;
        if (this.counterName != null) {
            chunksWithCounts = chunks.each(chunk -> {
                this.count("writeChunks chunks", 1L);
                this.count("writeChunks bytes", ((byte[])chunk).length);
            });
        }
        this.parent.write(this.prependStoragePath(key), (Scanner<byte[]>)chunksWithCounts);
        this.count("writeChunks ops", 1L);
    }

    @Override
    public void write(PathbeanKey key, InputStream inputStream) {
        this.parent.write(this.prependStoragePath(key), inputStream);
        this.count("writeInputStream ops", 1L);
    }

    @Override
    public void delete(PathbeanKey key) {
        this.parent.delete(this.prependStoragePath(key));
        this.count("delete ops", 1L);
    }

    @Override
    public void deleteAll(Subpath subpath) {
        this.parent.deleteAll(this.subpathInParent.append(subpath));
        this.count("deleteAll ops", 1L);
    }

    @Override
    public String getBucket() {
        return this.parent.getBucket();
    }

    @Override
    public Subpath getRootPath() {
        return this.parent.getRootPath().append(this.subpathInParent);
    }

    @Override
    public boolean exists(PathbeanKey key) {
        boolean exists = this.parent.exists(this.prependStoragePath(key));
        this.count("exists ops", 1L);
        return exists;
    }

    @Override
    public Optional<Long> length(PathbeanKey key) {
        Optional<Long> optLength = this.parent.length(this.prependStoragePath(key));
        this.count("length ops", 1L);
        return optLength;
    }

    @Override
    public byte[] read(PathbeanKey key) {
        Optional<byte[]> optBytes = Optional.ofNullable(this.parent.read(this.prependStoragePath(key)));
        this.count("read ops", 1L);
        optBytes.map(bytes -> ((byte[])bytes).length).ifPresent(length -> this.count("read bytes", length.intValue()));
        return optBytes.orElse(null);
    }

    @Override
    public byte[] read(PathbeanKey key, long offset, int length) {
        Optional<byte[]> optBytes = Optional.ofNullable(this.parent.read(this.prependStoragePath(key), offset, length));
        this.count("readOffsetLimit ops", 1L);
        optBytes.map(bytes -> ((byte[])bytes).length).ifPresent(actualLength -> this.count("readOffsetLimit bytes", actualLength.intValue()));
        return optBytes.orElse(null);
    }

    @Override
    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys) {
        HashMap<PathbeanKey, byte[]> keyValue = new HashMap<PathbeanKey, byte[]>();
        keys.forEach(key -> {
            Optional<byte[]> optBytes = Optional.ofNullable(this.parent.read(this.prependStoragePath((PathbeanKey)((Object)key))));
            this.count("read ops", 1L);
            optBytes.map(bytes -> ((byte[])bytes).length).ifPresent(actualLength -> this.count("read bytes", actualLength.intValue()));
            keyValue.putIfAbsent((PathbeanKey)((Object)key), optBytes.orElse(null));
        });
        return keyValue;
    }

    @Override
    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath) {
        return this.parent.scanKeysPaged(this.subpathInParent.append(subpath)).map(keys -> Scanner.of((Iterable)keys).map(this::removeStoragePath).list()).each($ -> this.count("scanKeys ops", 1L)).each(page -> this.count("scanKeys items", page.size()));
    }

    @Override
    public Scanner<List<Pathbean>> scanPaged(Subpath subpath) {
        return this.parent.scanPaged(this.subpathInParent.append(subpath)).map(page -> Scanner.of((Iterable)page).map(pathbean -> new Pathbean(this.removeStoragePath((PathbeanKey)pathbean.getKey()), pathbean.getSize())).list()).each($ -> this.count("scan ops", 1L)).each(page -> this.count("scan items", page.size()));
    }

    private PathbeanKey prependStoragePath(PathbeanKey directoryKey) {
        Subpath storagePath = this.subpathInParent.append(directoryKey.getSubpath());
        return PathbeanKey.of(storagePath, directoryKey.getFile());
    }

    private PathbeanKey removeStoragePath(PathbeanKey storageKey) {
        String storagePath = storageKey.getPath();
        Require.isTrue((boolean)storagePath.startsWith(this.subpathInParent.toString()));
        String directoryPath = storagePath.substring(this.subpathInParent.toString().length());
        return new PathbeanKey(directoryPath, storageKey.getFile());
    }

    private void count(String suffix, long by) {
        if (this.counterName != null) {
            String name = String.format("Directory %s %s", this.counterName, suffix);
            Counters.inc((String)name, (long)by);
        }
    }

    public String toString() {
        return this.getRootPath().toString();
    }
}

