/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.dao;

import io.datarouter.storage.dao.Dao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Singleton;

@Singleton
public class DaoClasses
implements Supplier<List<Class<? extends Dao>>> {
    private final List<Class<? extends Dao>> classes = new ArrayList<Class<? extends Dao>>();

    public DaoClasses() {
    }

    @SafeVarargs
    public DaoClasses(Class<? extends Dao> ... daoClassVarArgs) {
        this(List.of(daoClassVarArgs));
    }

    public DaoClasses(Collection<Class<? extends Dao>> daoClasses) {
        daoClasses.forEach(this::add);
    }

    @Override
    public List<Class<? extends Dao>> get() {
        return this.classes;
    }

    public DaoClasses add(Class<? extends Dao> daoClass) {
        this.requireUnique(daoClass);
        this.classes.add(daoClass);
        return this;
    }

    public DaoClasses add(List<Class<? extends Dao>> daoClasses) {
        daoClasses.forEach(this::add);
        return this;
    }

    private void requireUnique(Class<? extends Dao> daoClass) {
        if (this.classes.contains(daoClass)) {
            throw new IllegalArgumentException(String.valueOf(daoClass.getCanonicalName()) + " has already been registered");
        }
    }
}

