/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.setting.impl;

import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.setting.impl.DatarouterClientAvailabilitySwitchThresholdSettingsProvider;
import io.datarouter.storage.setting.Setting;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.constant.ConstantBooleanSetting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterClientAvailabilitySettings
extends SettingNode {
    public static final String SETTING_PREFIX = "datarouterStorage.availability.";
    public static final String READ = "read";
    public static final String WRITE = "write";
    private final Map<ClientId, AvailabilitySettingNode> availabilityByClientName = new ConcurrentHashMap<ClientId, AvailabilitySettingNode>();

    @Inject
    public DatarouterClientAvailabilitySettings(SettingFinder finder, DatarouterClientAvailabilitySwitchThresholdSettingsProvider clientAvailabilitySwitchThresholdSettingsProvider) {
        super(finder, SETTING_PREFIX);
        this.registerChild(clientAvailabilitySwitchThresholdSettingsProvider.get());
    }

    public AvailabilitySettingNode getAvailabilityForClientId(ClientId clientId) {
        if (clientId == null) {
            return new AvailabilitySettingNode(this, clientId, false);
        }
        return this.availabilityByClientName.computeIfAbsent(clientId, name -> new AvailabilitySettingNode(this, (ClientId)name, clientId.getDisableable()));
    }

    public static class AvailabilitySettingNode
    extends SettingNode {
        public final Setting<Boolean> read;
        public final Setting<Boolean> write;

        public AvailabilitySettingNode(DatarouterClientAvailabilitySettings availabilitySettings, ClientId clientId, boolean disableable) {
            super(availabilitySettings.finder, String.valueOf(availabilitySettings.getName()) + clientId.getName() + ".");
            if (disableable) {
                availabilitySettings.registerChild(this);
                this.read = this.registerBoolean(DatarouterClientAvailabilitySettings.READ, true);
                this.write = this.registerBoolean(DatarouterClientAvailabilitySettings.WRITE, true);
            } else {
                this.read = ConstantBooleanSetting.TRUE;
                this.write = ConstantBooleanSetting.TRUE;
            }
        }
    }
}

