/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptionsFactory;
import io.datarouter.storage.config.BaseStoragePlugin;
import io.datarouter.storage.config.schema.SchemaUpdateOptionsFactory;
import io.datarouter.storage.config.setting.DatarouterSettingOverrides;
import io.datarouter.storage.config.setting.DatarouterStorageSettingRoot;
import io.datarouter.storage.config.storage.clusterschemaupdatelock.DatarouterClusterSchemaUpdateLockDao;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaoClasses;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.setting.SettingRootsSupplier;
import java.util.ArrayList;
import java.util.List;

public class DatarouterStoragePlugin
extends BaseStoragePlugin {
    private final ServerTypes serverTypes;
    private final Class<? extends ServerTypeDetector> serverTypeDetectorClass;
    private final Class<? extends DatarouterSettingOverrides> settingOverridesClass;
    private final SettingRootsSupplier settingRoots;
    private final Class<? extends ClientOptionsFactory> clientOptionsFactoryClass;
    private final Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass;
    private final List<Class<? extends Dao>> daoClasses;
    private final DatarouterStorageDaosModule daosModule;

    private DatarouterStoragePlugin(DatarouterStorageDaosModule daosModule) {
        this(null, null, null, null, null, null, null, daosModule);
    }

    private DatarouterStoragePlugin(ServerTypes serverTypes, Class<? extends ServerTypeDetector> serverTypeDetectorClass, Class<? extends DatarouterSettingOverrides> settingOverridesClass, SettingRootsSupplier settingRoots, Class<? extends ClientOptionsFactory> clientOptionsFactoryClass, Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass, List<Class<? extends Dao>> daoClasses, DatarouterStorageDaosModule daosModule) {
        this.daosModule = daosModule;
        this.serverTypes = serverTypes;
        this.serverTypeDetectorClass = serverTypeDetectorClass;
        this.settingOverridesClass = settingOverridesClass;
        this.settingRoots = settingRoots;
        this.clientOptionsFactoryClass = clientOptionsFactoryClass;
        this.schemaUpdateOptionsFactoryClass = schemaUpdateOptionsFactoryClass;
        this.daoClasses = daoClasses;
        this.addSettingRoot(DatarouterStorageSettingRoot.class);
        this.setDaosModule(daosModule);
    }

    public List<Class<? extends Dao>> getDatarouterStorageDaoClasses() {
        return this.daosModule.getDaoClasses();
    }

    public void configure() {
        this.bind(ServerTypes.class).toInstance((Object)this.serverTypes);
        this.bindActual(ServerTypeDetector.class, this.serverTypeDetectorClass);
        if (this.settingOverridesClass != null) {
            this.bind(this.settingOverridesClass).asEagerSingleton();
        }
        if (this.settingRoots != null) {
            this.bindActualInstance(SettingRootsSupplier.class, this.settingRoots);
        }
        if (this.clientOptionsFactoryClass != null) {
            this.bindActual(ClientOptionsFactory.class, this.clientOptionsFactoryClass);
        }
        if (this.schemaUpdateOptionsFactoryClass != null) {
            this.bindActual(SchemaUpdateOptionsFactory.class, this.schemaUpdateOptionsFactoryClass);
        }
        this.bind(DaoClasses.class).toInstance((Object)new DaoClasses(this.daoClasses));
    }

    public static class DatarouterStorageDaosModule
    extends DaosModuleBuilder {
        private final List<ClientId> defaultClientIds;

        public DatarouterStorageDaosModule(List<ClientId> defaultClientId) {
            this.defaultClientIds = defaultClientId;
        }

        @Override
        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(DatarouterClusterSchemaUpdateLockDao.class);
        }

        public void configure() {
            this.bind(DatarouterClusterSchemaUpdateLockDao.DatarouterClusterSchemaUpdateLockDaoParams.class).toInstance((Object)new DatarouterClusterSchemaUpdateLockDao.DatarouterClusterSchemaUpdateLockDaoParams(this.defaultClientIds));
        }
    }

    public static class DatarouterStoragePluginBuilder {
        private final ServerTypes serverTypes;
        private final List<ClientId> defaultClientIds;
        private Class<? extends ServerTypeDetector> serverTypeDetectorClass = ServerTypeDetector.NoOpServerTypeDetector.class;
        private Class<? extends DatarouterSettingOverrides> settingOverridesClass;
        private SettingRootsSupplier settingRoots;
        private Class<? extends ClientOptionsFactory> clientOptionsFactoryClass;
        private Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass;
        private List<Class<? extends Dao>> daoClasses = new ArrayList<Class<? extends Dao>>();

        public DatarouterStoragePluginBuilder(ServerTypes serverTypes, List<ClientId> defaultClientIds) {
            this.serverTypes = serverTypes;
            this.defaultClientIds = defaultClientIds;
        }

        public DatarouterStoragePluginBuilder setServerTypeDetector(Class<? extends ServerTypeDetector> serveTypeDetectorClass) {
            this.serverTypeDetectorClass = serveTypeDetectorClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setSettingOverridesClass(Class<? extends DatarouterSettingOverrides> settingOverridesClass) {
            this.settingOverridesClass = settingOverridesClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setSettingRootsClass(SettingRootsSupplier settingRoots) {
            this.settingRoots = settingRoots;
            return this;
        }

        public DatarouterStoragePluginBuilder setClientOptionsFactoryClass(Class<? extends ClientOptionsFactory> clientOptionsFactoryClass) {
            this.clientOptionsFactoryClass = clientOptionsFactoryClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setSchemaUpdateOptionsFactoryClass(Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass) {
            this.schemaUpdateOptionsFactoryClass = schemaUpdateOptionsFactoryClass;
            return this;
        }

        public DatarouterStoragePluginBuilder addDao(Class<? extends Dao> dao) {
            this.daoClasses.add(dao);
            return this;
        }

        public DatarouterStoragePluginBuilder addDaosClasses(List<Class<? extends Dao>> daos) {
            this.daoClasses.addAll(daos);
            return this;
        }

        public DatarouterStoragePlugin getSimplePluginData() {
            return new DatarouterStoragePlugin(new DatarouterStorageDaosModule(this.defaultClientIds));
        }

        public DatarouterStoragePlugin build() {
            return new DatarouterStoragePlugin(this.serverTypes, this.serverTypeDetectorClass, this.settingOverridesClass, this.settingRoots, this.clientOptionsFactoryClass, this.schemaUpdateOptionsFactoryClass, this.daoClasses, new DatarouterStorageDaosModule(this.defaultClientIds));
        }
    }
}

