/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import com.google.inject.Module;
import io.datarouter.inject.InjectionTool;
import io.datarouter.inject.guice.BasePlugin;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.storage.setting.SettingRoot;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseStoragePlugin
extends BasePlugin {
    private final List<Class<? extends SettingRoot>> settingRoots = new ArrayList<Class<? extends SettingRoot>>();
    private DaosModuleBuilder daosModule = new DaosModuleBuilder.EmptyDaosModuleBuilder();
    private final List<BaseStoragePlugin> storagePlugins = new ArrayList<BaseStoragePlugin>();
    private final List<Module> testModules = new ArrayList<Module>();

    protected void addSettingRoot(Class<? extends SettingRoot> settingRoot) {
        this.settingRoots.add(settingRoot);
    }

    protected void setDaosModule(DaosModuleBuilder daosModule) {
        this.daosModule = daosModule;
    }

    protected void setDaosModule(final List<Pair<Class<? extends Dao>, List<ClientId>>> daosAndClients) {
        this.daosModule = new DaosModuleBuilder(){

            @Override
            public List<Class<? extends Dao>> getDaoClasses() {
                return Scanner.of((Iterable)daosAndClients).map(Pair::getLeft).list();
            }

            protected void configure() {
                for (Pair pair : daosAndClients) {
                    this.buildAndBindDaoParam((Pair<Class<? extends Dao>, List<ClientId>>)pair);
                }
            }

            private <T> void buildAndBindDaoParam(Pair<Class<? extends Dao>, List<ClientId>> pair) {
                Class daoParamsClass = (Class)InjectionTool.findInjectableClasses((Class)((Class)pair.getLeft())).include(clazz -> BaseRedundantDaoParams.class.isAssignableFrom((Class<?>)clazz)).findFirst().orElseThrow(() -> new RuntimeException("no injected BaseDaoParams found for " + pair.getLeft()));
                Object daoParamInstance = ReflectionTool.createWithParameters((Class)daoParamsClass, List.of((List)pair.getRight()));
                this.bind(daoParamsClass).toInstance(daoParamInstance);
            }
        };
    }

    public DaosModuleBuilder getDaosModuleBuilder() {
        return this.daosModule;
    }

    public List<Class<? extends SettingRoot>> getSettingRoots() {
        return this.settingRoots;
    }

    protected void addStoragePlugin(BaseStoragePlugin storagePlugin) {
        this.storagePlugins.add(storagePlugin);
    }

    public List<BaseStoragePlugin> getStoragePlugins() {
        return this.storagePlugins;
    }

    protected void addTestModule(Module testModule) {
        this.testModules.add(testModule);
    }

    public List<Module> getTestModules() {
        return this.testModules;
    }
}

