/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.callsite;

import io.datarouter.storage.callsite.CallsiteReportHeader;
import io.datarouter.storage.callsite.CallsiteStat;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;

public class CallsiteStatReportMetadata {
    private long maxCount = 0L;
    private long maxDurationUs = 0L;
    private long maxAvgDurationUs = 0L;
    private long maxItems = 0L;
    private long maxAvgItems = 0L;
    private int widthNodeName = 0;
    private int widthDatarouterMethod = 0;

    public void inspect(CallsiteStat stat) {
        this.maxCount = Math.max(this.maxCount, stat.getCount());
        this.maxDurationUs = Math.max(this.maxDurationUs, stat.getDurationNs());
        this.maxAvgDurationUs = Math.max(this.maxAvgDurationUs, stat.getAvgDurationUs());
        this.maxItems = Math.max(this.maxItems, stat.getNumItems());
        this.maxAvgItems = Math.max(this.maxAvgItems, stat.getAvgItems());
        this.widthNodeName = Math.max(this.widthNodeName, StringTool.length((String)stat.getKey().getNodeName()));
        this.widthDatarouterMethod = Math.max(this.widthDatarouterMethod, StringTool.length((String)stat.getDatarouterMethodName()));
    }

    public static CallsiteStatReportMetadata inspect(Iterable<CallsiteStat> stats) {
        CallsiteStatReportMetadata reportMetadata = new CallsiteStatReportMetadata();
        stats.forEach(reportMetadata::inspect);
        return reportMetadata;
    }

    public int getCountLength() {
        return Math.max(CallsiteReportHeader.count.length(), NumberFormatter.addCommas((Number)this.maxCount).length());
    }

    public int getDurationUsLength() {
        return Math.max(CallsiteReportHeader.microSec.length(), NumberFormatter.addCommas((Number)this.maxDurationUs).length());
    }

    public int getAvgDurationUsLength() {
        return Math.max(CallsiteReportHeader.avgMicroSec.length(), NumberFormatter.addCommas((Number)this.maxAvgDurationUs).length());
    }

    public int getItemsLength() {
        return Math.max(CallsiteReportHeader.numItems.length(), NumberFormatter.addCommas((Number)this.maxItems).length());
    }

    public int getAvgItemsLength() {
        return Math.max(CallsiteReportHeader.avgItems.length(), NumberFormatter.addCommas((Number)this.maxAvgItems).length());
    }

    public int getWidthNodeName() {
        return Math.max(CallsiteReportHeader.node.length(), this.widthNodeName);
    }

    public int getWidthDatarouterMethod() {
        return Math.max(CallsiteReportHeader.method.length(), this.widthDatarouterMethod);
    }
}

