/**
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.storage.node.op.index;

import java.util.Collection;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.config.Config;

public interface UniqueIndexWriter<
		PK extends PrimaryKey<PK>,
		D extends Databean<PK,D>,
		IK extends PrimaryKey<IK>>{

	public static final String OP_deleteUnique = "deleteUnique";
	public static final String OP_deleteMultiUnique = "deleteMultiUnique";

	void deleteUnique(IK indexKey, Config config);

	default void deleteUnique(IK indexKey){
		deleteUnique(indexKey, new Config());
	}

	void deleteMultiUnique(Collection<IK> uniqueKeys, Config config);

	default void deleteMultiUnique(Collection<IK> uniqueKeys){
		deleteMultiUnique(uniqueKeys, new Config());
	}

}
