/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.pathnode.PathNode;
import io.datarouter.scanner.Scanner;
import java.util.Collection;
import java.util.List;

public class Subpath {
    private static final String SLASH = "/";
    private static final Subpath EMPTY = new Subpath(new String[0]);
    private final String[] segments;
    private final String rendered;

    public Subpath(String ... segments) {
        Scanner.of((Object[])segments).forEach(Subpath::validateSegment);
        this.segments = segments;
        this.rendered = this.render();
    }

    public Subpath(List<String> segments) {
        this((String[])segments.toArray(String[]::new));
    }

    public Subpath(PathNode pathNode) {
        this(pathNode.toStringArray());
    }

    public Subpath append(String segment) {
        Subpath.validateSegment(segment);
        return (Subpath)Scanner.of((Object[])this.segments).append((Object[])new String[]{segment}).listTo(Subpath::new);
    }

    public Subpath append(Subpath suffix) {
        return (Subpath)Scanner.of((Object[])this.segments).append((Object[])suffix.segments).listTo(Subpath::new);
    }

    public static Subpath join(Collection<Subpath> paths) {
        return (Subpath)Scanner.of(paths).map(path -> path.segments).concat(stringArray -> Scanner.of((Object[])stringArray)).listTo(Subpath::new);
    }

    public static Subpath empty() {
        return EMPTY;
    }

    public String toString() {
        return this.rendered;
    }

    private static void validateSegment(String segment) {
        if (segment == null) {
            throw new IllegalArgumentException("segment cannot be null");
        }
        if (segment.contains(SLASH)) {
            throw new IllegalArgumentException("segment cannot contain slash");
        }
    }

    private String render() {
        if (this.segments.length == 0) {
            return "";
        }
        return String.valueOf(String.join((CharSequence)SLASH, this.segments)) + SLASH;
    }
}

