/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.gson.GsonTool;
import io.datarouter.storage.util.Ec2InstanceDetailsDto;
import io.datarouter.util.net.NetTool;
import java.time.Duration;
import java.util.Optional;

public class Ec2InstanceTool {
    public static final String EC2_TOKEN_URL = "http://169.254.169.254/latest/api/token";
    public static final String EC2_INSTANCE_IDENTITY_DOCUMENT_URL = "http://169.254.169.254/latest/dynamic/instance-identity/document";
    public static final String EC2_PRIVATE_IP_URL = "http://169.254.169.254/latest/meta-data/local-ipv4";
    public static final String EC2_PUBLIC_IP_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";
    public static final String TTL_HEADER = "X-aws-ec2-metadata-token-ttl-seconds";
    public static final String TOKEN_HEADER = "X-aws-ec2-metadata-token";
    private static final String TTL_S = Long.toString(Duration.ofSeconds(10L).toSeconds());

    private static Optional<String> makeEc2Call(String ec2Url, boolean logError) {
        return NetTool.curl((String)"PUT", (String)EC2_TOKEN_URL, (boolean)logError, (NetTool.Header)new NetTool.Header(TTL_HEADER, TTL_S)).flatMap(token -> NetTool.curl((String)"GET", (String)ec2Url, (boolean)logError, (NetTool.Header)new NetTool.Header(TOKEN_HEADER, token))).or(() -> NetTool.curl((String)"GET", (String)ec2Url, (boolean)logError, null));
    }

    public static Optional<Ec2InstanceDetailsDto> getEc2InstanceDetails(boolean logError) {
        return Ec2InstanceTool.makeEc2Call(EC2_INSTANCE_IDENTITY_DOCUMENT_URL, logError).map(json -> (Ec2InstanceDetailsDto)GsonTool.withUnregisteredEnums().fromJson(json, Ec2InstanceDetailsDto.class));
    }

    public static String getEc2InstancePublicIp() {
        return Ec2InstanceTool.makeEc2Call(EC2_PUBLIC_IP_URL, false).orElse(null);
    }

    public static String getEc2InstancePrivateIp() {
        return Ec2InstanceTool.makeEc2Call(EC2_PUBLIC_IP_URL, false).orElse(null);
    }

    public static boolean isEc2() {
        return Ec2InstanceTool.getEc2InstanceDetails(false).isPresent();
    }
}

