/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.kvfile.KvFileNameAndSize;
import io.datarouter.bytes.kvfile.KvFileStorage;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.tuple.Range;
import java.io.InputStream;
import java.util.List;

public class DirectoryKvFileStorage
implements KvFileStorage {
    private final Directory directory;

    public DirectoryKvFileStorage(Directory directory) {
        this.directory = directory;
    }

    public List<KvFileNameAndSize> list() {
        return this.directory.scan(Subpath.empty()).map(pathbean -> new KvFileNameAndSize(((PathbeanKey)pathbean.getKey()).getFile(), pathbean.getSize().longValue())).list();
    }

    public void write(String name, byte[] value) {
        this.directory.write(PathbeanKey.of(name), value);
    }

    public void writeParallel(String name, Scanner<List<byte[]>> parts, Threads threads) {
        this.directory.writeParallel(PathbeanKey.of(name), parts, threads);
    }

    public byte[] read(String name) {
        return this.directory.read(PathbeanKey.of(name));
    }

    public InputStream readInputStream(String name) {
        return this.directory.readInputStream(PathbeanKey.of(name));
    }

    public Scanner<byte[]> readParallel(String name, long fromInclusive, long toExclusive, Threads threads, ByteLength chunkSize) {
        return this.directory.scanChunks(PathbeanKey.of(name), (Range<Long>)new Range((Object)fromInclusive, true, (Object)toExclusive, false), threads, chunkSize);
    }

    public void delete(String name) {
        this.directory.delete(PathbeanKey.of(name));
    }
}

