/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.storage.metric.Gauges;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterQueueMetrics {
    public static final String QUEUE_LENGTH = "queue length";
    public static final String OLDEST_MESSAGE_AGE_S = "oldestMessageAgeS";
    public static final String OLDEST_MESSAGE_AGE_M = "oldestMessageAgeM";
    @Inject
    private Gauges gauges;

    public static String makeNameForOldestMessageAgeS(String clientTypeName, String queueName) {
        return DatarouterQueueMetrics.makeMetricName(clientTypeName, OLDEST_MESSAGE_AGE_S, queueName);
    }

    public static String makeNameForQueueLength(String clientTypeName, String queueName) {
        return DatarouterQueueMetrics.makeMetricName(clientTypeName, QUEUE_LENGTH, queueName);
    }

    private static String makeMetricName(String clientTypeName, String key, String queueName) {
        return "Datarouter " + clientTypeName + " " + key + " " + queueName;
    }

    public void saveQueueLength(String key, long queueLength, String clientTypeName) {
        this.gauges.save(DatarouterQueueMetrics.makeNameForQueueLength(clientTypeName, key), queueLength);
    }

    public void saveOldestAckMessageAge(String key, long oldestUnackedMessageAgeS, String clientTypeName) {
        this.gauges.save(DatarouterQueueMetrics.makeNameForOldestMessageAgeS(clientTypeName, key), oldestUnackedMessageAgeS);
    }
}

