/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting.cached;

import io.datarouter.storage.config.environment.DatarouterEnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.setting.DatarouterSettingTag;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.DefaultSettingValueWinner;
import io.datarouter.storage.setting.Setting;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.util.cached.Cached;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class CachedSetting<T>
extends Cached<T>
implements Setting<T> {
    protected final SettingFinder finder;
    protected final String name;
    protected final DefaultSettingValue<T> defaultSettingValue;
    protected boolean hasCustomValues;
    protected boolean hasRedundantCustomValues;

    public CachedSetting(SettingFinder finder, String name, DefaultSettingValue<T> defaultValue) {
        super(5L, TimeUnit.SECONDS);
        this.finder = finder;
        this.name = name;
        this.defaultSettingValue = defaultValue;
    }

    public String toString() {
        return "CachedSetting=" + this.name;
    }

    protected T reload() {
        return (T)this.finder.getSettingValue(this.name).map(this::parseStringValue).orElseGet(this::getDefaultValue);
    }

    public Optional<T> getMostSpecificDatabeanValue() {
        return this.finder.getSettingValue(this.name).map(this::parseStringValue);
    }

    public void validateAllCustomValuesCanBeParsed() {
        try {
            this.finder.getAllCustomSettingValues(this.name).forEach(this::parseStringValue);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("value is not valid for setting name=" + this.name, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultSettingValue.getValue(this.finder.getEnvironmentType(), this.finder.getEnvironmentCategoryName(), this.finder.getEnvironmentName(), this.finder.getServerType(), this.finder.getServiceName(), this.finder.getServerName(), this.finder.getSettingTags());
    }

    public String toStringValue(T value) {
        return String.valueOf(value);
    }

    public String toStringValue() {
        return this.toStringValue(this.get());
    }

    public String toStringDefaultValue() {
        return this.toStringValue(this.defaultSettingValue.getGlobalDefault());
    }

    @Override
    public boolean getHasCustomValue() {
        return this.get() != null;
    }

    @Override
    public boolean getHasRedundantCustomValue() {
        return Objects.equals(this.getDefaultValue(), this.get());
    }

    public CachedSetting<T> setGlobalDefault(T value) {
        this.defaultSettingValue.setGlobalDefault(value);
        return this;
    }

    public CachedSetting<T> setEnvironmentTypeDefault(Supplier<DatarouterEnvironmentType> environmentType, T value) {
        this.defaultSettingValue.withEnvironmentType(environmentType, value);
        return this;
    }

    public CachedSetting<T> setEnvironmentTypesDefault(Collection<Supplier<DatarouterEnvironmentType>> environmentTypes, T value) {
        environmentTypes.forEach(environmentType -> {
            CachedSetting<Object> cachedSetting = this.setEnvironmentTypeDefault((Supplier<DatarouterEnvironmentType>)environmentType, value);
        });
        return this;
    }

    public CachedSetting<T> setEnvironmentNameDefault(Supplier<DatarouterEnvironmentType> environmentType, String environmentName, T value) {
        this.defaultSettingValue.withEnvironmentName(environmentType, environmentName, value);
        return this;
    }

    public CachedSetting<T> setEnvironmentCategoryNameDefault(Supplier<DatarouterEnvironmentType> environmentType, String environmentCategoryName, T value) {
        this.defaultSettingValue.withEnvironmentCategoryName(environmentType, environmentCategoryName, value);
        return this;
    }

    public CachedSetting<T> setServerTypeDefault(Supplier<DatarouterEnvironmentType> environmentType, ServerType serverType, T value) {
        this.defaultSettingValue.withServerType(environmentType, serverType, value);
        return this;
    }

    public CachedSetting<T> setServerNameDefault(Supplier<DatarouterEnvironmentType> environmentType, String serverName, T value) {
        this.defaultSettingValue.withServerName(environmentType, serverName, value);
        return this;
    }

    public CachedSetting<T> setServiceNameDefault(Supplier<DatarouterEnvironmentType> environmentType, String serviceName, T value) {
        this.defaultSettingValue.withServiceName(environmentType, serviceName, value);
        return this;
    }

    public CachedSetting<T> setTagDefault(Supplier<DatarouterSettingTag> tagTypeSupplier, Supplier<T> value) {
        this.defaultSettingValue.withTag(tagTypeSupplier, value);
        return this;
    }

    public DefaultSettingValue<T> getDefaultSettingValue() {
        return this.defaultSettingValue;
    }

    public DefaultSettingValueWinner getDefaultSettingValueWinner() {
        this.defaultSettingValue.getValue(this.finder.getEnvironmentType(), this.finder.getEnvironmentCategoryName(), this.finder.getEnvironmentName(), this.finder.getServerType(), this.finder.getServiceName(), this.finder.getServerName(), this.finder.getSettingTags());
        return this.defaultSettingValue.getDefaultSettingValueWinner();
    }
}

