/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.instrumentation.test.TestableService;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.SettingRoot;
import io.datarouter.storage.setting.SettingRootsSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SettingBootstrapIntegrationService
implements TestableService {
    @Inject
    private DatarouterInjector datarouterInjector;
    @Inject
    private SettingRootsSupplier settingRootsSupplier;
    @Inject
    private SettingRoot.SettingRootFinder settingRootFinder;

    @Override
    public void testAll() {
        String orphanSettings = this.datarouterInjector.getInstancesOfType(SettingNode.class).entrySet().stream().map(Map.Entry::getValue).filter(node -> node != this.settingRootFinder).filter(node -> !this.isInTree((SettingNode)node, (List<? extends SettingNode>)this.settingRootsSupplier.get())).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "));
        if (!orphanSettings.isEmpty()) {
            throw new RuntimeException("some setting nodes are not registered: " + orphanSettings);
        }
    }

    private boolean isInTree(SettingNode needle, List<? extends SettingNode> haystack) {
        boolean presentAtThisLevel = haystack.stream().anyMatch(node -> needle == node);
        if (presentAtThisLevel) {
            return true;
        }
        return haystack.stream().map(SettingNode::getListChildren).anyMatch(leaves -> this.isInTree(needle, (List<? extends SettingNode>)leaves));
    }
}

