/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.storage.config.environment.DatarouterEnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.setting.DatarouterSettingTag;
import io.datarouter.storage.setting.DefaultSettingValueWinner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class DefaultSettingValue<T> {
    private T globalDefault;
    private final Map<DatarouterEnvironmentType, T> valueByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByServerTypeByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByServiceNameByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByServerNameByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByEnvironmentNameByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByEnvironmentCategoryNameByEnvironmentType;
    private final Map<DatarouterSettingTag, Supplier<T>> valueBySettingTag;
    private DefaultSettingValueWinner defaultSettingValueWinner;

    public DefaultSettingValue(T globalDefault) {
        this.globalDefault = globalDefault;
        this.valueByEnvironmentType = new HashMap<DatarouterEnvironmentType, T>();
        this.valueByServerTypeByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByServiceNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByServerNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByEnvironmentNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByEnvironmentCategoryNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueBySettingTag = new HashMap<DatarouterSettingTag, Supplier<T>>();
        this.defaultSettingValueWinner = DefaultSettingValueWinner.globalDefault();
    }

    public DefaultSettingValue<T> withEnvironmentType(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, T value) {
        this.valueByEnvironmentType.put(environmentTypeSupplier.get(), value);
        return this;
    }

    public DefaultSettingValue<T> withEnvironmentName(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, String environment, T value) {
        this.valueByEnvironmentNameByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(environment, value);
        return this;
    }

    public DefaultSettingValue<T> withEnvironmentCategoryName(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, String categoryName, T value) {
        this.valueByEnvironmentCategoryNameByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(categoryName, value);
        return this;
    }

    public DefaultSettingValue<T> withServerType(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, ServerType serverType, T value) {
        this.valueByServerTypeByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(serverType.getPersistentString(), value);
        return this;
    }

    public DefaultSettingValue<T> withServiceName(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, String serviceName, T value) {
        this.valueByServiceNameByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(serviceName, value);
        return this;
    }

    public DefaultSettingValue<T> withServerName(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, String serverName, T value) {
        this.valueByServerNameByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(serverName, value);
        return this;
    }

    public DefaultSettingValue<T> withTag(Supplier<DatarouterSettingTag> tagTypeSupplier, Supplier<T> value) {
        this.valueBySettingTag.put(tagTypeSupplier.get(), value);
        return this;
    }

    public DefaultSettingValue<T> setGlobalDefault(T value) {
        this.globalDefault = value;
        return this;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByServerTypeByEnvironmentType() {
        return this.valueByServerTypeByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByServerNameByEnvironmentType() {
        return this.valueByServerNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByServiceNameByEnvironmentType() {
        return this.valueByServiceNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByEnvironmentNameByEnvironmentType() {
        return this.valueByEnvironmentNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByEnvironmentCategoryNameByEnvironmentType() {
        return this.valueByEnvironmentCategoryNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, T> getValueByEnvironmentType() {
        return this.valueByEnvironmentType;
    }

    public Map<DatarouterSettingTag, Supplier<T>> getValueBySettingTag() {
        return this.valueBySettingTag;
    }

    public Map<String, T> getValueByServerName(DatarouterEnvironmentType environmentType) {
        return this.valueByServerNameByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public Map<String, T> getValueByServerType(DatarouterEnvironmentType environmentType) {
        return this.valueByServerTypeByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public Map<String, T> getValueByServiceName(DatarouterEnvironmentType environmentType) {
        return this.valueByServiceNameByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public Map<String, T> getValueByEnvironmentName(DatarouterEnvironmentType environmentType) {
        return this.valueByEnvironmentNameByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public Map<String, T> getValueByEnvironmentCategoryName(DatarouterEnvironmentType environmentType) {
        return this.valueByEnvironmentCategoryNameByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public T getGlobalDefault() {
        return this.globalDefault;
    }

    public T getValue(String environmentTypeString, String environmentCategoryName, String environmentName, ServerType serverType, String serviceName, String serverName, List<DatarouterSettingTag> settingTags) {
        return this.getValue(new DatarouterEnvironmentType(environmentTypeString), environmentCategoryName, environmentName, serverType, serviceName, serverName, settingTags);
    }

    public T getValue(DatarouterEnvironmentType environmentType, String environmentCategoryName, String environmentName, ServerType serverType, String serviceName, String serverName, List<DatarouterSettingTag> settingTags) {
        String serverTypeString = serverType == null ? null : serverType.getPersistentString();
        return this.getValue(environmentType, environmentCategoryName, environmentName, serverTypeString, serviceName, serverName, settingTags);
    }

    public T getValue(DatarouterEnvironmentType environmentType, String environmentCategoryName, String environmentName, String serverTypeString, String serviceName, String serverName, List<DatarouterSettingTag> settingTags) {
        T value;
        T value2;
        T value3;
        T value4;
        T value5;
        Map<String, T> valueByServerName = this.getValueByServerName(environmentType);
        if (!valueByServerName.isEmpty() && (value5 = valueByServerName.get(serverName)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.SERVER_NAME, environmentType.getPersistentString(), environmentCategoryName, environmentName, serverTypeString, serviceName, serverName, String.valueOf(value5));
            return value5;
        }
        Map<String, T> valueByServiceName = this.getValueByServiceName(environmentType);
        if (!valueByServiceName.isEmpty() && (value4 = valueByServiceName.get(serviceName)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.SERVICE_NAME, environmentType.getPersistentString(), environmentCategoryName, environmentName, serverTypeString, serviceName, serverName, String.valueOf(value4));
            return value4;
        }
        Map<String, T> valueByServerType = this.getValueByServerType(environmentType);
        if (!valueByServerType.isEmpty() && (value3 = valueByServerType.get(serverTypeString)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.SERVER_TYPE, environmentType.getPersistentString(), environmentCategoryName, environmentName, serverTypeString, serviceName, serverName, String.valueOf(value3));
            return value3;
        }
        Map<String, T> valueByEnvironmentName = this.getValueByEnvironmentName(environmentType);
        if (!valueByEnvironmentName.isEmpty() && (value2 = valueByEnvironmentName.get(environmentName)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.ENVIRONMENT_NAME, environmentType.getPersistentString(), environmentCategoryName, environmentName, serverTypeString, serviceName, serverName, String.valueOf(value2));
            return value2;
        }
        Map<String, T> valueByEnvironmentCategoryName = this.getValueByEnvironmentCategoryName(environmentType);
        if (!valueByEnvironmentCategoryName.isEmpty() && (value = valueByEnvironmentCategoryName.get(environmentCategoryName)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.ENVIRONMENT_CATEGORY, environmentType.getPersistentString(), environmentCategoryName, environmentName, serverTypeString, serviceName, serverName, String.valueOf(value));
            return value;
        }
        T valueForEnvironmentType = this.valueByEnvironmentType.get(environmentType);
        if (valueForEnvironmentType != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.ENVIRONMENT_TYPE, environmentType.getPersistentString(), environmentCategoryName, environmentName, serverTypeString, serviceName, serverName, String.valueOf(valueForEnvironmentType));
            return valueForEnvironmentType;
        }
        Optional<DatarouterSettingTag> matchedTag = settingTags.stream().filter(this.valueBySettingTag::containsKey).findFirst();
        if (matchedTag.isPresent()) {
            T value6 = this.valueBySettingTag.get(matchedTag.get()).get();
            this.defaultSettingValueWinner = DefaultSettingValueWinner.settingTag(matchedTag.get().getPersistentString(), String.valueOf(value6));
            return value6;
        }
        this.defaultSettingValueWinner = DefaultSettingValueWinner.globalDefault();
        return this.globalDefault;
    }

    public DefaultSettingValueWinner getDefaultSettingValueWinner() {
        return this.defaultSettingValueWinner;
    }
}

