/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.servertype;

import io.datarouter.enums.web.HtmlSelectOptionBean;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.servertype.SingleServerType;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class BaseServerTypes
implements ServerTypes {
    private final Set<ServerType> serverTypes = new TreeSet<ServerType>();
    private final ServerType webServerType;
    private final ServerType jobServerType;
    private final ServerType jobletServerType;

    public BaseServerTypes(ServerType defaultServerType) {
        this(defaultServerType, defaultServerType, defaultServerType);
    }

    protected BaseServerTypes(ServerType webServerType, ServerType jobServerType, ServerType jobletServerType) {
        this.serverTypes.add(ServerType.ALL);
        this.serverTypes.add(ServerType.DEV);
        this.serverTypes.add(ServerType.UNKNOWN);
        this.webServerType = webServerType;
        this.jobServerType = jobServerType;
        this.jobletServerType = jobletServerType;
        this.serverTypes.addAll(List.of(webServerType, jobServerType, jobletServerType));
    }

    public static ServerType makeProduction(String persistentString, boolean isHttpExposed) {
        return new SingleServerType(persistentString, true, isHttpExposed);
    }

    public BaseServerTypes add(ServerType serverType) {
        this.serverTypes.add(serverType);
        return this;
    }

    @Override
    public Scanner<ServerType> values() {
        return Scanner.of(this.serverTypes);
    }

    @Override
    public ServerType getWebServerType() {
        return this.webServerType;
    }

    @Override
    public ServerType getJobServerType() {
        return this.jobServerType;
    }

    @Override
    public ServerType getJobletServerType() {
        return this.jobletServerType;
    }

    @Override
    public ServerType fromPersistentString(String str) {
        return (ServerType)this.values().include(serverType -> serverType.getPersistentString().equals(str)).findFirst().orElseThrow(() -> new RuntimeException("Unknown server type: " + str));
    }

    @Override
    public List<HtmlSelectOptionBean> getHtmlSelectOptionsVarNames() {
        return this.values().map(serverType -> new HtmlSelectOptionBean(serverType.getDisplay(), serverType.getPersistentString())).list();
    }
}

