/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.serialize.fieldcache;

import io.datarouter.model.entity.Entity;
import io.datarouter.model.field.Field;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.storage.node.entity.EntityNodeParams;
import java.util.List;
import java.util.function.Supplier;

public class EntityFieldInfo<EK extends EntityKey<EK>, E extends Entity<EK>> {
    public static final byte ENTITY_PREFIX_TERMINATOR = 0;
    private final String entityTableName;
    private final Supplier<EK> entityKeySupplier;
    private final EK sampleEntityKey;
    private final EntityPartitioner<EK> entityPartitioner;
    private final Supplier<E> entitySupplier;
    private final List<Field<?>> entityKeyFields;

    public EntityFieldInfo(EntityNodeParams<EK, E> params) {
        this.entityTableName = params.getEntityTableName();
        this.entityKeySupplier = params.getEntityKeySupplier();
        this.sampleEntityKey = (EntityKey)this.entityKeySupplier.get();
        this.entityPartitioner = params.getEntityPartitionerSupplier().get();
        this.entitySupplier = params.getEntitySupplier();
        this.entityKeyFields = ((EntityKey)this.entityKeySupplier.get()).getFields();
    }

    public static byte getEntityPrefixTerminator() {
        return 0;
    }

    public String getEntityTableName() {
        return this.entityTableName;
    }

    public Supplier<EK> getEntityKeySupplier() {
        return this.entityKeySupplier;
    }

    public EK getSampleEntityKey() {
        return this.sampleEntityKey;
    }

    public EntityPartitioner<EK> getEntityPartitioner() {
        return this.entityPartitioner;
    }

    public Supplier<E> getEntitySupplier() {
        return this.entitySupplier;
    }

    public List<Field<?>> getEntityKeyFields() {
        return this.entityKeyFields;
    }
}

