/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.serialize.fieldcache;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.FieldKey;
import io.datarouter.model.field.encoding.FieldGeneratorType;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.string.StringTool;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DatabeanFieldInfo<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final byte ENTITY_PREFIX_TERMINATOR = 0;
    private final Supplier<PK> primaryKeySupplier;
    private final PK samplePrimaryKey;
    private final Supplier<D> databeanSupplier;
    private final D sampleDatabean;
    private final Field keyJavaField;
    private final Map<String, List<io.datarouter.model.field.Field<?>>> uniqueIndexes;
    private final boolean subEntity;
    private final String entityNodePrefix;
    private final byte[] entityNodeColumnPrefixBytes;
    private final List<io.datarouter.model.field.Field<?>> ekFields;
    private final List<io.datarouter.model.field.Field<?>> ekPkFields;
    private final List<io.datarouter.model.field.Field<?>> postEkPkKeyFields;
    private final boolean singleDatabeanEntity;
    private final Supplier<F> fielderSupplier;
    private final F sampleFielder;
    private final FieldGeneratorType autoGeneratedType;
    private String autoGeneratedFieldName;
    private final Optional<Long> ttlMs;
    private final List<io.datarouter.model.field.Field<?>> primaryKeyFields;
    private final List<io.datarouter.model.field.Field<?>> nonKeyFields;
    private final List<io.datarouter.model.field.Field<?>> fields;
    private final Supplier<Boolean> recordCallsite;
    private final Map<String, io.datarouter.model.field.Field<?>> nonKeyFieldByColumnName = new HashMap();
    private final Map<String, io.datarouter.model.field.Field<?>> fieldByColumnName = new HashMap();
    private final Map<String, io.datarouter.model.field.Field<?>> fieldByPrefixedName = new HashMap();
    private final List<String> primaryKeyFieldColumnNames;
    private final List<String> fieldColumnNames;
    private final List<String> nonKeyFieldColumnNames;

    public DatabeanFieldInfo(NodeParams<PK, D, F> params) {
        this.databeanSupplier = params.getDatabeanSupplier();
        this.sampleDatabean = (Databean)this.databeanSupplier.get();
        this.primaryKeySupplier = this.sampleDatabean.getKeySupplier();
        this.samplePrimaryKey = (PrimaryKey)this.primaryKeySupplier.get();
        this.fielderSupplier = params.getFielderSupplier();
        this.sampleFielder = (DatabeanFielder)this.fielderSupplier.get();
        this.autoGeneratedType = this.detectAutoGeneratedType();
        this.ttlMs = this.sampleFielder.getTtlMs();
        this.recordCallsite = params.getRecordCallsites();
        this.primaryKeyFields = this.samplePrimaryKey.getFields();
        this.fields = this.sampleFielder.getFields(this.sampleDatabean);
        this.addFieldsToCollections();
        this.nonKeyFields = this.sampleFielder.getNonKeyFields(this.sampleDatabean);
        this.addNonKeyFieldsToCollections();
        this.uniqueIndexes = new HashMap(this.sampleFielder.getUniqueIndexes(this.sampleDatabean));
        this.primaryKeyFieldColumnNames = DatabeanFieldInfo.createFieldColumnNames(this.primaryKeyFields);
        this.fieldColumnNames = DatabeanFieldInfo.createFieldColumnNames(this.fields);
        this.nonKeyFieldColumnNames = DatabeanFieldInfo.createFieldColumnNames(this.nonKeyFields);
        this.keyJavaField = ReflectionTool.getDeclaredFieldFromAncestors(this.sampleDatabean.getClass(), (String)this.sampleDatabean.getKeyFieldName());
        this.subEntity = StringTool.notEmpty((String)params.getEntityNodePrefix());
        this.entityNodePrefix = params.getEntityNodePrefix();
        this.entityNodeColumnPrefixBytes = this.entityNodePrefix == null ? null : ByteTool.concat((byte[][])new byte[][]{StringCodec.UTF_8.encode(this.entityNodePrefix), new byte[1]});
        EntityPrimaryKey sampleEntityPrimaryKey = (EntityPrimaryKey)this.samplePrimaryKey;
        this.ekFields = sampleEntityPrimaryKey.getEntityKey().getFields();
        this.ekPkFields = sampleEntityPrimaryKey.getEntityKeyFields();
        this.postEkPkKeyFields = sampleEntityPrimaryKey.getPostEntityKeyFields();
        this.singleDatabeanEntity = this.postEkPkKeyFields.isEmpty();
    }

    public io.datarouter.model.field.Field<?> getFieldForColumnName(String columnName) {
        return this.fieldByColumnName.get(columnName);
    }

    public List<io.datarouter.model.field.Field<?>> getFieldsWithValues(D databean) {
        return this.sampleFielder.getFields(databean);
    }

    public List<io.datarouter.model.field.Field<?>> getNonKeyFieldsWithValues(D databean) {
        return this.sampleFielder.getNonKeyFields(databean);
    }

    private static List<String> createFieldColumnNames(List<io.datarouter.model.field.Field<?>> fields) {
        return fields.stream().map(io.datarouter.model.field.Field::getKey).map(FieldKey::getColumnName).collect(Collectors.toList());
    }

    private void addNonKeyFieldsToCollections() {
        for (io.datarouter.model.field.Field<?> field : this.nonKeyFields) {
            this.nonKeyFieldByColumnName.put(field.getKey().getColumnName(), field);
        }
    }

    private void addFieldsToCollections() {
        for (io.datarouter.model.field.Field<?> field : this.fields) {
            this.fieldByColumnName.put(field.getKey().getColumnName(), field);
            this.fieldByPrefixedName.put(field.getPrefixedName(), field);
        }
    }

    private FieldGeneratorType detectAutoGeneratedType() {
        for (io.datarouter.model.field.Field field : this.samplePrimaryKey.getFields()) {
            if (!field.getKey().getAutoGeneratedType().isGenerated()) continue;
            this.autoGeneratedFieldName = field.getKey().getName();
            return field.getKey().getAutoGeneratedType();
        }
        return FieldGeneratorType.NONE;
    }

    public Supplier<PK> getPrimaryKeySupplier() {
        return this.primaryKeySupplier;
    }

    public PK getSamplePrimaryKey() {
        return this.samplePrimaryKey;
    }

    public Supplier<D> getDatabeanSupplier() {
        return this.databeanSupplier;
    }

    public D getSampleDatabean() {
        return this.sampleDatabean;
    }

    public Supplier<F> getFielderSupplier() {
        return this.fielderSupplier;
    }

    public F getSampleFielder() {
        return this.sampleFielder;
    }

    public List<io.datarouter.model.field.Field<?>> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public List<io.datarouter.model.field.Field<?>> getNonKeyFields() {
        return this.nonKeyFields;
    }

    public List<io.datarouter.model.field.Field<?>> getFields() {
        return this.fields;
    }

    public Map<String, io.datarouter.model.field.Field<?>> getFieldByColumnName() {
        return this.fieldByColumnName;
    }

    public Map<String, io.datarouter.model.field.Field<?>> getNonKeyFieldByColumnName() {
        return this.nonKeyFieldByColumnName;
    }

    public Map<String, io.datarouter.model.field.Field<?>> getFieldByPrefixedName() {
        return this.fieldByPrefixedName;
    }

    public Map<String, List<io.datarouter.model.field.Field<?>>> getUniqueIndexes() {
        return this.uniqueIndexes;
    }

    public FieldGeneratorType getAutoGeneratedType() {
        return this.autoGeneratedType;
    }

    public boolean isManagedAutoGeneratedId() {
        return FieldGeneratorType.MANAGED == this.autoGeneratedType;
    }

    public String getAutogeneratedFieldName() {
        return this.autoGeneratedFieldName;
    }

    public String getEntityNodePrefix() {
        return this.entityNodePrefix;
    }

    public byte[] getEntityColumnPrefixBytes() {
        return this.entityNodeColumnPrefixBytes;
    }

    public Field getKeyJavaField() {
        return this.keyJavaField;
    }

    public boolean isSubEntity() {
        return this.subEntity;
    }

    public List<io.datarouter.model.field.Field<?>> getEkFields() {
        return this.ekFields;
    }

    public List<io.datarouter.model.field.Field<?>> getEkPkFields() {
        return this.ekPkFields;
    }

    public List<io.datarouter.model.field.Field<?>> getPostEkPkKeyFields() {
        return this.postEkPkKeyFields;
    }

    public boolean isSingleDatabeanEntity() {
        return this.singleDatabeanEntity;
    }

    public Optional<Long> getTtlMs() {
        return this.ttlMs;
    }

    public Supplier<Boolean> getRecordCallsite() {
        return this.recordCallsite;
    }

    public List<String> getPrimaryKeyFieldColumnNames() {
        return this.primaryKeyFieldColumnNames;
    }

    public List<String> getFieldColumnNames() {
        return this.fieldColumnNames;
    }

    public List<String> getNonKeyFieldColumnNames() {
        return this.nonKeyFieldColumnNames;
    }
}

