/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.queue.consumer;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.QueueMessage;
import io.datarouter.storage.queue.QueueMessageKey;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;

public class QueueConsumer<PK extends PrimaryKey<PK>, D extends Databean<PK, D>> {
    private final Function<Config, QueueMessage<PK, D>> peekFunction;
    private final Consumer<QueueMessageKey> ackConsumer;

    public QueueConsumer(Function<Config, QueueMessage<PK, D>> peekFunction, Consumer<QueueMessageKey> ackConsumer) {
        this.peekFunction = peekFunction;
        this.ackConsumer = ackConsumer;
    }

    public QueueMessage<PK, D> peek(Duration timeout) {
        return this.peekFunction.apply(new Config().setTimeout(timeout));
    }

    public QueueMessage<PK, D> peek(Duration timeout, Duration visibilityTimeout) {
        return this.peekFunction.apply(new Config().setTimeout(timeout).setVisibilityTimeoutMs(visibilityTimeout.toMillis()));
    }

    public void ack(QueueMessageKey key) {
        this.ackConsumer.accept(key);
    }
}

