/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.queue.consumer;

import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.queue.BlobQueueMessage;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlobQueueConsumer<T> {
    private final Function<Config, Optional<BlobQueueMessage<T>>> peekFunction = storage::peek;
    private final Consumer<BlobQueueMessage<T>> ackConsumer = storage::ack;

    public BlobQueueConsumer(BlobQueueStorage<T> storage) {
    }

    public Optional<BlobQueueMessage<T>> peek(Duration timeout) {
        return this.peekFunction.apply(new Config().setTimeout(timeout));
    }

    public Optional<BlobQueueMessage<T>> peek(Duration timeout, Duration visibilityTimeout) {
        return this.peekFunction.apply(new Config().setTimeout(timeout).setVisibilityTimeoutMs(visibilityTimeout.toMillis()));
    }

    public void ack(BlobQueueMessage<T> key) {
        this.ackConsumer.accept(key);
    }
}

