/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.queue.consumer;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.QueueMessage;
import io.datarouter.storage.queue.QueueMessageKey;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class BatchedQueueConsumer<PK extends PrimaryKey<PK>, D extends Databean<PK, D>> {
    private final Function<Config, List<QueueMessage<PK, D>>> peekMultiFunction;
    private final BiConsumer<Collection<QueueMessageKey>, Config> ackMultiConsumer;

    public BatchedQueueConsumer(Function<Config, List<QueueMessage<PK, D>>> peekMultiFunction, BiConsumer<Collection<QueueMessageKey>, Config> ackMultiConsumer) {
        this.peekMultiFunction = peekMultiFunction;
        this.ackMultiConsumer = ackMultiConsumer;
    }

    public List<QueueMessage<PK, D>> peekMulti(Integer limit, Duration timeout, Duration visibilityTimeout) {
        return this.peekMultiFunction.apply(new Config().setLimit(limit).setTimeout(timeout).setVisibilityTimeoutMs(visibilityTimeout.toMillis()));
    }

    public void ackMulti(Integer limit, Collection<QueueMessageKey> keys) {
        this.ackMultiConsumer.accept(keys, new Config().setLimit(limit));
    }
}

