/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.op.scan.stride;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.node.op.raw.read.SortedStorageReader;
import io.datarouter.storage.op.scan.stride.StrideSample;
import io.datarouter.storage.op.scan.stride.internal.InternalStrideSample;
import io.datarouter.storage.op.scan.stride.internal.InternalStrideScanner;
import io.datarouter.util.tuple.Range;
import java.util.Iterator;
import java.util.function.Supplier;

public class StrideScanner<PK extends PrimaryKey<PK>>
extends BaseScanner<StrideSample<PK>> {
    private final Iterator<InternalStrideSample<PK>> internalSampleIterator;
    private long totalCount;

    public StrideScanner(Scanner<InternalStrideSample<PK>> internalSampleScanner) {
        this.internalSampleIterator = internalSampleScanner.iterator();
    }

    public boolean advance() {
        if (!this.internalSampleIterator.hasNext()) {
            return false;
        }
        InternalStrideSample<PK> sample = this.internalSampleIterator.next();
        this.totalCount += sample.sampleCount;
        boolean isLast = !this.internalSampleIterator.hasNext();
        this.current = sample.toStrideSample(this.totalCount, isLast);
        return true;
    }

    public static class StrideScannerBuilder<PK extends PrimaryKey<PK>> {
        private final SortedStorageReader<PK, ?> node;
        private Supplier<Boolean> shouldStop;
        private Range<PK> range;
        private int stride;
        private int batchSize;
        private boolean log;

        public StrideScannerBuilder(SortedStorageReader<PK, ?> node) {
            this.node = node;
            this.shouldStop = () -> false;
            this.range = Range.everything();
            this.stride = 10000;
            this.batchSize = 1000;
            this.log = false;
        }

        public StrideScannerBuilder<PK> withShouldStop(Supplier<Boolean> shouldStop) {
            this.shouldStop = shouldStop;
            return this;
        }

        public StrideScannerBuilder<PK> withRange(Range<PK> range) {
            this.range = range;
            return this;
        }

        public StrideScannerBuilder<PK> withStride(int stride) {
            this.stride = stride;
            return this;
        }

        public StrideScannerBuilder<PK> withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public StrideScannerBuilder<PK> withLog(boolean log) {
            this.log = log;
            return this;
        }

        public StrideScanner<PK> build() {
            InternalStrideScanner<PK> internalScanner = new InternalStrideScanner<PK>(this.node, this.shouldStop, this.range, this.stride, this.batchSize, this.log);
            return new StrideScanner(internalScanner);
        }
    }
}

