/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.op.scan;

import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.storage.config.Config;
import io.datarouter.util.collection.ListTool;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNodeScanner<PK extends PrimaryKey<PK>, T extends Comparable<? super T>>
extends BaseScanner<List<T>> {
    private static final Logger logger = LoggerFactory.getLogger(BaseNodeScanner.class);
    private static final int DEFAULT_RANGE_BATCH_SIZE = 10;
    private static final int DEFAULT_RESPONSE_BATCH_SIZE = 100;
    private final NavigableSet<Range<PK>> ranges;
    private final Config config;
    private final int rangeBatchSize;
    private long resultCount;
    private SortedSet<Range<PK>> currentRanges;
    private Config batchConfig;
    private boolean foundLastBatch;
    private PK lastRowOfPreviousBatch;

    public BaseNodeScanner(Collection<Range<PK>> ranges, Config config, boolean caseInsensitive) {
        this.warnIfCaseInsensitive(ranges, caseInsensitive);
        this.config = config;
        this.rangeBatchSize = this.config.findRequestBatchSize().orElse(10);
        this.ranges = ranges.stream().filter(Range::notEmpty).collect(Collectors.toCollection(TreeSet::new));
        this.currentRanges = new TreeSet<Range<PK>>();
        this.fillCurrentRanges();
        this.resultCount = 0L;
        this.batchConfig = this.config.getDeepCopy();
        this.foundLastBatch = false;
    }

    protected abstract PK getPrimaryKey(T var1);

    protected abstract List<T> loadRanges(Collection<Range<PK>> var1, Config var2);

    public boolean advance() {
        if (this.foundLastBatch) {
            return false;
        }
        if (this.currentRanges.isEmpty()) {
            return false;
        }
        if (this.current != null) {
            Range previousRange = null;
            TreeSet<Range<PK>> remainingRanges = new TreeSet<Range<PK>>(this.currentRanges);
            for (Range range : this.currentRanges) {
                if (previousRange != null) {
                    if (range.getStart() == null || ((PrimaryKey)range.getStart()).compareTo(this.lastRowOfPreviousBatch) > 0) break;
                    remainingRanges.remove(previousRange);
                    if (!this.ranges.isEmpty()) {
                        remainingRanges.add(this.ranges.pollFirst());
                    }
                }
                previousRange = range;
            }
            this.currentRanges = remainingRanges;
            if (this.currentRanges.isEmpty()) {
                return false;
            }
            Range range = this.currentRanges.first().clone();
            range.setStart(this.lastRowOfPreviousBatch);
            range.setStartInclusive(false);
            this.currentRanges.remove(this.currentRanges.first());
            if (!range.isEmpty()) {
                this.currentRanges.add(range);
            } else if (!this.ranges.isEmpty()) {
                this.currentRanges.add(this.ranges.pollFirst());
            } else if (this.currentRanges.isEmpty()) {
                return false;
            }
        }
        this.updateBatchConfigLimit();
        this.current = this.loadRanges(this.currentRanges, this.batchConfig);
        while (((List)this.current).isEmpty() && !this.ranges.isEmpty()) {
            this.currentRanges.clear();
            this.fillCurrentRanges();
            this.current = this.loadRanges(this.currentRanges, this.batchConfig);
        }
        this.batchConfig.setOffset(0);
        this.resultCount += (long)((List)this.current).size();
        if (this.ranges.size() == 0 && ((List)this.current).size() < this.batchConfig.getLimit() || this.config.getLimit() != null && this.resultCount >= (long)this.config.getLimit().intValue()) {
            this.foundLastBatch = true;
        }
        this.lastRowOfPreviousBatch = ListTool.findLast((List)((List)this.current)).map(this::getPrimaryKey).map(FieldSetTool::clone).orElse(null);
        return !((List)this.current).isEmpty();
    }

    private void warnIfCaseInsensitive(Collection<Range<PK>> ranges, boolean caseInsensitive) {
        if (ranges.size() > 1 && caseInsensitive) {
            logger.warn("scan multi on case insensitive table " + ranges.stream().filter(Range::hasStart).map(Range::getStart).map(Object::getClass).findAny());
        }
    }

    private void fillCurrentRanges() {
        int i = 0;
        while (i < this.rangeBatchSize && !this.ranges.isEmpty()) {
            this.currentRanges.add(this.ranges.pollFirst());
            ++i;
        }
    }

    private void updateBatchConfigLimit() {
        int batchConfigLimit = this.config.findResponseBatchSize().orElse(100);
        if (this.config.getLimit() != null && (long)this.config.getLimit().intValue() - this.resultCount < (long)batchConfigLimit) {
            batchConfigLimit = (int)((long)this.config.getLimit().intValue() - this.resultCount);
        }
        this.batchConfig.setLimit(batchConfigLimit);
    }
}

