/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.raw.write;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.MultiByteArrayInputStream;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.op.raw.read.BlobStorageReader;
import io.datarouter.storage.util.Subpath;
import java.io.InputStream;
import java.util.List;

public interface BlobStorageWriter
extends BlobStorageReader {
    public void write(PathbeanKey var1, byte[] var2, Config var3);

    default public void write(PathbeanKey key, byte[] value) {
        this.write(key, value, new Config());
    }

    default public void write(PathbeanKey key, Scanner<byte[]> chunks, Config config) {
        MultiByteArrayInputStream inputStream = new MultiByteArrayInputStream(chunks);
        this.write(key, (InputStream)inputStream, config);
    }

    default public void write(PathbeanKey key, Scanner<byte[]> chunks) {
        this.write(key, chunks, new Config());
    }

    public void write(PathbeanKey var1, InputStream var2, Config var3);

    default public void write(PathbeanKey key, InputStream inputStream) {
        this.write(key, inputStream, new Config());
    }

    default public void writeParallel(PathbeanKey key, InputStream inputStream, Threads threads, ByteLength minPartSize, Config config) {
        this.write(key, inputStream, config);
    }

    default public void writeParallel(PathbeanKey key, InputStream inputStream, Threads threads, ByteLength minPartSize) {
        this.writeParallel(key, inputStream, threads, minPartSize, new Config());
    }

    default public void writeParallel(PathbeanKey key, Scanner<List<byte[]>> parts, Threads threads, Config config) {
        this.write(key, (InputStream)parts.concat(Scanner::of).apply(MultiByteArrayInputStream::new), config);
    }

    default public void writeParallel(PathbeanKey key, Scanner<List<byte[]>> parts, Threads threads) {
        this.writeParallel(key, parts, threads, new Config());
    }

    public void delete(PathbeanKey var1, Config var2);

    default public void delete(PathbeanKey key) {
        this.delete(key, new Config());
    }

    public void deleteAll(Subpath var1, Config var2);

    default public void deleteAll(Subpath subpath) {
        this.deleteAll(subpath, new Config());
    }

    public void vacuum(Config var1);
}

