/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.raw.read;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.MultiByteArrayInputStream;
import io.datarouter.bytes.split.ChunkScannerTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.BucketAndPrefix;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.node.op.raw.read.DirectoryDto;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.tuple.Range;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface BlobStorageReader
extends NodeOps<PathbeanKey, Pathbean> {
    public String getBucket();

    public Subpath getRootPath();

    public boolean exists(PathbeanKey var1, Config var2);

    default public boolean exists(PathbeanKey key) {
        return this.exists(key, new Config());
    }

    public Optional<Long> length(PathbeanKey var1, Config var2);

    default public Optional<Long> length(PathbeanKey key) {
        return this.length(key, new Config());
    }

    public byte[] read(PathbeanKey var1, Config var2);

    default public byte[] read(PathbeanKey key) {
        return this.read(key, new Config());
    }

    public byte[] read(PathbeanKey var1, long var2, int var4, Config var5);

    default public byte[] read(PathbeanKey key, long offset, int length) {
        return this.read(key, offset, length, new Config());
    }

    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> var1, Config var2);

    default public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys) {
        return this.read(keys, new Config());
    }

    default public InputStream readInputStream(PathbeanKey key, Config config) {
        return (InputStream)this.scanChunks(key, (Range<Long>)Range.everything(), ByteLength.ofMiB((long)4L)).apply(MultiByteArrayInputStream::new);
    }

    default public InputStream readInputStream(PathbeanKey key) {
        return this.readInputStream(key, new Config());
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath var1, Config var2);

    default public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath) {
        return this.scanKeysPaged(subpath, new Config());
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath var1, Config var2);

    default public Scanner<List<Pathbean>> scanPaged(Subpath subpath) {
        return this.scanPaged(subpath, new Config());
    }

    default public Scanner<PathbeanKey> scanKeys(Subpath subpath, Config config) {
        return this.scanKeysPaged(subpath, config).concat(Scanner::of);
    }

    default public Scanner<PathbeanKey> scanKeys(Subpath subpath) {
        return this.scanKeys(subpath, new Config());
    }

    default public Scanner<Pathbean> scan(Subpath subpath) {
        return this.scanPaged(subpath).concat(Scanner::of);
    }

    default public Scanner<byte[]> scanChunks(PathbeanKey key, Range<Long> range, ByteLength chunkSize) {
        long fromInclusive = range.hasStart() ? (Long)range.getStart() : 0L;
        long toExclusive = range.hasEnd() ? (Long)range.getEnd() : this.length(key).orElseThrow();
        return ChunkScannerTool.scanChunks((long)fromInclusive, (long)toExclusive, (int)chunkSize.toBytesInt()).map(chunkRange -> this.read(key, chunkRange.start, chunkRange.length));
    }

    default public Scanner<byte[]> scanChunks(PathbeanKey key, Range<Long> range, Threads threads, ByteLength chunkSize) {
        long fromInclusive = range.hasStart() ? (Long)range.getStart() : 0L;
        long toExclusive = range.hasEnd() ? (Long)range.getEnd() : this.length(key).orElseThrow();
        return ChunkScannerTool.scanChunks((long)fromInclusive, (long)toExclusive, (int)chunkSize.toBytesInt()).parallelOrdered(threads).map(chunkRange -> this.read(key, chunkRange.start, chunkRange.length));
    }

    default public Scanner<DirectoryDto> scanDirectories(BucketAndPrefix locationPrefix, String startAfter, int pageSize) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    default public Scanner<DirectoryDto> scanFiles(BucketAndPrefix locationPrefix, String startAfter, int pageSize) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

