/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.raw;

import io.datarouter.bytes.BatchingByteArrayScanner;
import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.VarIntByteArraysTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.model.databean.EmptyDatabean;
import io.datarouter.model.key.EmptyDatabeanKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.exception.DataTooLargeException;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.queue.BlobQueueMessage;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface BlobQueueStorage<T> {
    public static final String OP_getMaxDataSize = "getMaxDataSize";
    public static final String OP_put = "put";
    public static final String OP_peek = "peek";
    public static final String OP_ack = "ack";
    public static final String OP_poll = "poll";

    public int getMaxRawDataSize();

    default public boolean willFit(T data) {
        return ((byte[])this.getCodec().encode(data)).length < this.getMaxRawDataSize();
    }

    public Codec<T, byte[]> getCodec();

    public void putRaw(byte[] var1, Config var2);

    default public void putRaw(byte[] data) {
        this.putRaw(data, new Config());
    }

    default public void put(T data, Config config) {
        this.combineAndPut(Scanner.of(data), config);
    }

    default public void put(T data) {
        this.put(data, new Config());
    }

    default public void putMulti(Collection<T> data, Config config) {
        this.combineAndPut(Scanner.of(data), config);
    }

    default public void putMulti(Collection<T> data) {
        this.putMulti(data, new Config());
    }

    default public void putMulti(Scanner<T> data, Config config) {
        this.combineAndPut(data, config);
    }

    default public void putMulti(Scanner<T> data) {
        this.putMulti(data, new Config());
    }

    public Optional<BlobQueueMessage<T>> peek(Config var1);

    default public Optional<BlobQueueMessage<T>> peek() {
        return this.peek(new Config());
    }

    public void ack(byte[] var1, Config var2);

    default public void ack(byte[] handle) {
        this.ack(handle, new Config());
    }

    default public void ack(BlobQueueMessage<T> blobQueueMessage, Config config) {
        this.ack(blobQueueMessage.getHandle(), config);
    }

    default public void ack(BlobQueueMessage<T> blobQueueMessage) {
        this.ack(blobQueueMessage, new Config());
    }

    default public Optional<BlobQueueMessage<T>> poll(Config config) {
        Optional<BlobQueueMessage<BlobQueueMessage>> optionalMessage = this.peek(config);
        optionalMessage.ifPresent(message -> this.ack((BlobQueueMessage<T>)message, config));
        return optionalMessage;
    }

    default public Optional<BlobQueueMessage<T>> poll() {
        return this.poll(new Config());
    }

    default public void combineAndPut(Scanner<T> data) {
        this.combineAndPut(data, new Config());
    }

    default public void combineAndPut(Scanner<T> data, Config config) {
        ((BatchingByteArrayScanner)data.map(arg_0 -> this.getCodec().encode(arg_0)).each(bytes -> {
            if (((byte[])bytes).length > this.getMaxRawDataSize() - VarIntTool.encode((long)((byte[])bytes).length).length) {
                throw new DataTooLargeException("BlobQueueStorage", List.of("a blob of size " + ((byte[])bytes).length));
            }
        }).map(VarIntByteArraysTool::encodeOne).apply(scanner -> new BatchingByteArrayScanner(scanner, this.getMaxRawDataSize()))).map(ByteTool::concat).forEach(bytes -> this.putRaw((byte[])bytes, config));
    }

    public static interface BlobQueueStorageNode<T>
    extends BlobQueueStorage<T>,
    Node<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> {
    }

    public static interface PhysicalBlobQueueStorageNode<T>
    extends BlobQueueStorageNode<T>,
    PhysicalNode<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> {
    }
}

