/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.combo;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.combo.reader.SortedMapStorageReader;
import io.datarouter.storage.node.op.combo.writer.SortedMapStorageWriter;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.SortedStorage;
import java.util.Collection;

public interface SortedMapStorage<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends MapStorage<PK, D>,
SortedStorage<PK, D>,
SortedMapStorageReader<PK, D>,
SortedMapStorageWriter<PK, D> {
    public static final int DELETE_BATCH_SIZE = 100;

    default public void deleteWithPrefix(PK prefix, Config config) {
        this.scanKeysWithPrefix(prefix, config).batch(100).forEach(keys -> this.deleteMulti(keys, config));
    }

    default public void deleteWithPrefix(PK prefix) {
        this.deleteWithPrefix(prefix, new Config());
    }

    default public void deleteWithPrefixes(Collection<PK> prefixes, Config config) {
        this.scanKeysWithPrefixes(prefixes, config).batch(100).forEach(keys -> this.deleteMulti(keys, config));
    }

    default public void deleteWithPrefixes(Collection<PK> prefixes) {
        this.deleteWithPrefixes(prefixes, new Config());
    }

    public static interface PhysicalSortedMapStorageNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends SortedMapStorageNode<PK, D, F>,
    MapStorage.PhysicalMapStorageNode<PK, D, F>,
    SortedStorage.PhysicalSortedStorageNode<PK, D, F>,
    SortedMapStorageReader.PhysicalSortedMapStorageReaderNode<PK, D, F>,
    SortedMapStorageWriter.PhysicalSortedMapStorageWriterNode<PK, D, F> {
    }

    public static interface SortedMapStorageNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends SortedMapStorage<PK, D>,
    MapStorage.MapStorageNode<PK, D, F>,
    SortedStorage.SortedStorageNode<PK, D, F>,
    SortedMapStorageReader.SortedMapStorageReaderNode<PK, D, F>,
    SortedMapStorageWriter.SortedMapStorageWriterNode<PK, D, F> {
    }
}

