/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.bytes.Codec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.EmptyDatabean;
import io.datarouter.model.key.EmptyDatabeanKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.imp.BlobQueueClientNodeFactory;
import io.datarouter.storage.client.imp.QueueClientNodeFactory;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.BlobQueueNodeBuilder;
import io.datarouter.storage.node.builder.GroupQueueNodeBuilder;
import io.datarouter.storage.node.builder.QueueNodeBuilder;
import io.datarouter.storage.node.builder.SingleQueueNodeBuilder;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.util.Require;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class QueueNodeFactory
extends BaseNodeFactory {
    @Inject
    private Datarouter datarouter;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> QueueNodeBuilder<PK, D, F> createSingleQueue(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new SingleQueueNodeBuilder(this.datarouter, this, clientId, databeanSupplier, fielderSupplier);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> QueueNodeBuilder<PK, D, F> createGroupQueue(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new GroupQueueNodeBuilder(this.datarouter, this, clientId, databeanSupplier, fielderSupplier);
    }

    public <T> BlobQueueNodeBuilder<T> createBlobQueue(ClientId clientId, String queueName, Codec<T, byte[]> codec) {
        return new BlobQueueNodeBuilder<T>(this.datarouter, this, clientId, queueName, codec);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createSingleQueueNode(ClientId clientId, Supplier<D> databeanSupplier, String queueName, Supplier<F> fielderSupplier, String namespace, String queueUrl, Tag tag, boolean enableAgeMonitoring) {
        NodeParams params = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withTableName(queueName).withNamespace(namespace).withQueueUrl(queueUrl).withTag(tag).withAgeMonitoring(enableAgeMonitoring).build();
        QueueClientNodeFactory clientFactories = this.getClientNodeFactory(clientId, QueueClientNodeFactory.class);
        return QueueNodeFactory.cast(clientFactories.createSingleQueueNode(params));
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createGroupQueueNode(ClientId clientId, Supplier<D> databeanSupplier, String queueName, Supplier<F> fielderSupplier, String namespace, String queueUrl, Tag tag, boolean enableAgeMonitoring) {
        NodeParams params = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withTableName(queueName).withNamespace(namespace).withQueueUrl(queueUrl).withTag(tag).withAgeMonitoring(enableAgeMonitoring).build();
        QueueClientNodeFactory clientFactories = this.getClientNodeFactory(clientId, QueueClientNodeFactory.class);
        return QueueNodeFactory.cast(clientFactories.createGroupQueueNode(params));
    }

    public <T> BlobQueueStorage.BlobQueueStorageNode<T> createBlobQueueNode(ClientId clientId, String queueName, Codec<T, byte[]> codec, String namespace, String queueUrl, Tag tag, boolean enableAgeMonitoring) {
        Require.notBlank((String)queueName);
        NodeParams<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> params = new NodeParams.NodeParamsBuilder(EmptyDatabean::new, EmptyDatabean.EmptyDatabeanFielder::new).withClientId(clientId).withTableName(queueName).withNamespace(namespace).withQueueUrl(queueUrl).withTag(tag).withAgeMonitoring(enableAgeMonitoring).build();
        BlobQueueClientNodeFactory clientFactories = this.getClientNodeFactory(clientId, BlobQueueClientNodeFactory.class);
        return clientFactories.createBlobQueueNode(params, codec);
    }
}

