/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.file.DatabaseBlob;
import io.datarouter.storage.file.DatabaseBlobKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.BlobNodeBuilder;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.util.Subpath;
import java.util.function.Supplier;
import javax.inject.Singleton;

@Singleton
public class BlobNodeFactory
extends BaseNodeFactory {
    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> BlobNodeBuilder<PK, D, F> create(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new BlobNodeBuilder(this.datarouter, this, clientId, databeanSupplier, fielderSupplier);
    }

    public <PK extends PrimaryKey<PK>, N extends BlobStorage.PhysicalBlobStorageNode> N create(ClientId clientId, String bucketName, Subpath path) {
        NodeParams<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder> params = new NodeParams.NodeParamsBuilder(DatabaseBlob::new, DatabaseBlob.DatabaseBlobFielder::new).withClientId(clientId).withBucketName(bucketName).withPath(path).build();
        BlobClientNodeFactory clientFactories = this.getClientNodeFactory(clientId, BlobClientNodeFactory.class);
        return (N)((BlobStorage.PhysicalBlobStorageNode)BlobNodeFactory.cast(clientFactories.createBlobNode(params)));
    }
}

