/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.imp.DatabeanClientNodeFactory;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.NodeBuilder;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.function.Supplier;

public abstract class BaseDatabeanNodeFactory
extends BaseNodeFactory {
    private final Supplier<Boolean> enableDiagnosticsSupplier;

    public BaseDatabeanNodeFactory(Supplier<Boolean> enableDiagnosticsSupplier) {
        this.enableDiagnosticsSupplier = enableDiagnosticsSupplier;
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends PhysicalNode<PK, D, F>> N create(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params) {
        DatabeanClientNodeFactory clientNodeFactory = this.getClientNodeFactory(params.getClientId(), DatabeanClientNodeFactory.class);
        return (N)((PhysicalNode)BaseDatabeanNodeFactory.cast(clientNodeFactory.createDatabeanNode(entityNodeParams, params)));
    }

    public <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> NodeBuilder<EK, PK, D, F> create(ClientId clientId, Supplier<EK> entityKeySupplier, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new NodeBuilder(this, this.enableDiagnosticsSupplier, clientId, entityKeySupplier, databeanSupplier, fielderSupplier);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> NodeBuilder<PK, PK, D, F> create(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        Supplier entityKeySupplier = ((Databean)databeanSupplier.get()).getKeySupplier();
        return this.create(clientId, entityKeySupplier, databeanSupplier, fielderSupplier);
    }

    public <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends PhysicalNode<PK, D, F>> N register(N node) {
        return this.datarouter.register(node);
    }
}

