/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.builder;

import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.factory.TallyNodeFactory;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.storage.tally.Tally;
import java.util.function.Supplier;

public class TallyNodeBuilder {
    private final Datarouter datarouter;
    private final TallyNodeFactory nodeFactory;
    private final ClientId clientId;
    private final Supplier<Tally> databeanSupplier;
    private final Supplier<Tally.TallyFielder> fielderSupplier;
    private String version;
    private String tableName;
    private Tag tag;

    public TallyNodeBuilder(Datarouter datarouter, TallyNodeFactory nodeFactory, ClientId clientId, Supplier<Tally> databeanSupplier, Supplier<Tally.TallyFielder> fielderSupplier) {
        this.datarouter = datarouter;
        this.nodeFactory = nodeFactory;
        this.clientId = clientId;
        this.databeanSupplier = databeanSupplier;
        this.fielderSupplier = fielderSupplier;
    }

    public TallyNodeBuilder withSchemaVersion(String version) {
        this.version = version;
        return this;
    }

    public TallyNodeBuilder withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TallyNodeBuilder withTag(Tag tag) {
        this.tag = tag;
        return this;
    }

    public TallyStorage.PhysicalTallyStorageNode build() {
        return this.nodeFactory.createTallyNode(this.clientId, this.databeanSupplier, this.fielderSupplier, this.version, this.tableName, this.tag);
    }

    public TallyStorage.PhysicalTallyStorageNode buildAndRegister() {
        return this.datarouter.register(this.build());
    }
}

