/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.builder;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.unique.UniqueIndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.imp.TxnManagedUniqueIndexNode;
import io.datarouter.storage.node.op.combo.IndexedMapStorage;
import io.datarouter.storage.node.type.index.UniqueIndexNode;
import io.datarouter.storage.serialize.fieldcache.IndexEntryFieldInfo;
import java.util.function.Supplier;

public class ManagedNodeBuilder<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, IK extends PrimaryKey<IK>, IE extends UniqueIndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> {
    private final Supplier<IE> databeanSupplier;
    private final Supplier<IF> fielderSupplier;
    private final IndexedMapStorage<PK, D> backingNode;
    private String indexName;

    public ManagedNodeBuilder(Supplier<IK> indexEntryKeySupplier, Supplier<IE> databeanSupplier, Supplier<IF> fielderSupplier, IndexedMapStorage<PK, D> backingNode) {
        this.databeanSupplier = databeanSupplier;
        this.fielderSupplier = fielderSupplier;
        this.backingNode = backingNode;
        this.indexName = ((PrimaryKey)indexEntryKeySupplier.get()).getClass().getSimpleName();
    }

    public ManagedNodeBuilder<PK, D, IK, IE, IF> withTableName(String tableName) {
        this.indexName = tableName;
        return this;
    }

    public UniqueIndexNode<PK, D, IK, IE> build() {
        IndexEntryFieldInfo fieldInfo = new IndexEntryFieldInfo(this.indexName, this.databeanSupplier, this.fielderSupplier);
        return this.backingNode.registerManaged(new TxnManagedUniqueIndexNode(this.backingNode, fieldInfo, this.indexName));
    }
}

