/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.builder;

import io.datarouter.bytes.Codec;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.factory.QueueNodeFactory;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.tag.Tag;

public class BlobQueueNodeBuilder<T> {
    protected final Datarouter datarouter;
    protected final QueueNodeFactory queueNodeFactory;
    protected final ClientId clientId;
    protected final String queueName;
    protected final Codec<T, byte[]> codec;
    protected String namespace;
    protected String queueUrl;
    protected Tag tag;
    protected boolean enableAgeMonitoring = true;

    public BlobQueueNodeBuilder(Datarouter datarouter, QueueNodeFactory queueNodeFactory, ClientId clientId, String queueName, Codec<T, byte[]> codec) {
        this.datarouter = datarouter;
        this.queueNodeFactory = queueNodeFactory;
        this.clientId = clientId;
        this.queueName = queueName;
        this.codec = codec;
    }

    public BlobQueueNodeBuilder<T> withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public BlobQueueNodeBuilder<T> withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public BlobQueueNodeBuilder<T> withTag(Tag tag) {
        this.tag = tag;
        return this;
    }

    public BlobQueueNodeBuilder<T> withAgeMonitoring(boolean enableAgeMonitoring) {
        this.enableAgeMonitoring = enableAgeMonitoring;
        return this;
    }

    public BlobQueueStorage.BlobQueueStorageNode<T> buildAndRegister() {
        return this.datarouter.register(this.build());
    }

    public BlobQueueStorage.BlobQueueStorageNode<T> build() {
        return this.queueNodeFactory.createBlobQueueNode(this.clientId, this.queueName, this.codec, this.namespace, this.queueUrl, this.tag, this.enableAgeMonitoring);
    }
}

